/*
 * Decompiled with CFR 0.152.
 */
package fs;

import fs.File;
import fs.TextUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

class JSR75
implements File {
    FileConnection connection;
    String location = "";
    Hashtable cache = new Hashtable();

    public boolean close() throws  {
        boolean bl = true;
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (Exception exception) {
            System.err.println("Close connection failed: ".concat(String.valueOf(exception.getMessage())));
            bl = false;
        }
        return bl;
    }

    public boolean open(String string, int n) throws  {
        boolean bl = true;
        try {
            this.connection = (FileConnection)Connector.open((String)"file:///".concat(String.valueOf(string)), (int)n);
            this.location = string;
        }
        catch (Exception exception) {
            this.connection = null;
            System.err.println("Open connection '" + String.valueOf(string) + "' failed: " + String.valueOf(exception.getMessage()));
            bl = false;
        }
        return bl;
    }

    public boolean open(String string) throws  {
        boolean bl = true;
        try {
            this.connection = (FileConnection)Connector.open((String)"file:///".concat(String.valueOf(string)));
            this.location = string;
        }
        catch (Exception exception) {
            this.connection = null;
            System.err.println("Open connection '" + String.valueOf(string) + "' failed: " + String.valueOf(exception.getMessage()));
            bl = false;
        }
        return bl;
    }

    public String[] list(String string, boolean bl) throws  {
        Object[] objectArray = new String[]{};
        if (this.cache.containsKey(this.location)) {
            objectArray = (String[])this.cache.get(this.location);
            return objectArray;
        }
        if (this.connection != null) {
            Vector vector = new Vector();
            try {
                Enumeration enumeration = this.connection.list(string, bl);
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
            }
            catch (Exception exception) {
                System.err.println("Can't list the directory: ".concat(String.valueOf(exception.getMessage())));
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            vector.removeAllElements();
        } else {
            System.err.println("List failed: connection is null ");
        }
        objectArray = TextUtils.shellSort((String[])objectArray, false, true, true);
        if (!this.cache.containsKey(this.location)) {
            this.cache.put(this.location, objectArray);
        }
        return objectArray;
    }

    public String[] listRoots() throws  {
        Object[] objectArray = new String[]{};
        if (this.cache.containsKey(this.location)) {
            objectArray = (String[])this.cache.get(this.location);
            return objectArray;
        }
        Vector<String> vector = new Vector<String>();
        try {
            Enumeration enumeration = FileSystemRegistry.listRoots();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector.removeAllElements();
        objectArray = TextUtils.shellSort((String[])objectArray, false, true, true);
        if (!this.cache.containsKey(this.location)) {
            this.cache.put(this.location, objectArray);
        }
        return objectArray;
    }

    public boolean isDirectory() throws  {
        boolean bl = false;
        if (this.connection != null) {
            bl = this.connection.isDirectory();
        }
        return bl;
    }

    public InputStream openInputStream() throws  {
        InputStream inputStream = null;
        if (this.connection != null) {
            try {
                inputStream = this.connection.openInputStream();
            }
            catch (Exception exception) {
                inputStream = null;
                System.out.println("openInputStream from '" + String.valueOf(this.location) + "' failed: " + String.valueOf(exception.getMessage()));
            }
        }
        return inputStream;
    }

    public OutputStream openOutputStream() throws  {
        OutputStream outputStream = null;
        if (this.connection != null) {
            try {
                outputStream = this.connection.openOutputStream();
            }
            catch (Exception exception) {
                outputStream = null;
                System.out.println("openOutputStream from '" + String.valueOf(this.location) + "' failed: " + String.valueOf(exception.getMessage()));
            }
        }
        return outputStream;
    }

    public DataInputStream openDataInputStream() throws  {
        DataInputStream dataInputStream = null;
        if (this.connection != null) {
            try {
                dataInputStream = this.connection.openDataInputStream();
            }
            catch (Exception exception) {
                dataInputStream = null;
                System.out.println("openInputStream from '" + String.valueOf(this.location) + "' failed: " + String.valueOf(exception.getMessage()));
            }
        }
        return dataInputStream;
    }

    public DataOutputStream openDataOutputStream() throws  {
        DataOutputStream dataOutputStream = null;
        if (this.connection != null) {
            try {
                dataOutputStream = this.connection.openDataOutputStream();
            }
            catch (Exception exception) {
                dataOutputStream = null;
                System.out.println("openOutputStream from '" + String.valueOf(this.location) + "' failed: " + String.valueOf(exception.getMessage()));
            }
        }
        return dataOutputStream;
    }

    public boolean create() throws Exception {
        boolean bl = false;
        if (this.connection != null) {
            if (!this.connection.exists()) {
                this.connection.create();
                bl = true;
            }
            this.cache.remove(this.location);
        }
        return bl;
    }

    public boolean mkdir() throws Exception {
        boolean bl = false;
        if (this.connection != null) {
            if (!this.connection.exists()) {
                this.connection.mkdir();
                bl = true;
            }
            this.cache.remove(this.location);
        }
        return bl;
    }

    public boolean delete() throws Exception {
        boolean bl = false;
        if (this.connection != null) {
            if (this.connection.exists()) {
                this.connection.delete();
                bl = true;
            }
            this.cache.remove(this.location);
        }
        return bl;
    }

    public boolean exists() throws Exception {
        boolean bl = false;
        if (this.connection != null) {
            bl = this.connection.exists();
        }
        return bl;
    }

    public long fileSize() throws Exception {
        long l = -1L;
        if (this.connection != null) {
            l = this.connection.fileSize();
        }
        return l;
    }

    public long usedSize() throws Exception {
        long l = -1L;
        if (this.connection != null) {
            l = this.connection.usedSize();
        }
        return l;
    }

    public long availableSize() throws Exception {
        long l = -1L;
        if (this.connection != null) {
            l = this.connection.availableSize();
        }
        return l;
    }

    public long totalSize() throws Exception {
        long l = -1L;
        if (this.connection != null) {
            l = this.connection.totalSize();
        }
        return l;
    }

    public long directorySize(boolean bl) throws Exception {
        long l = -1L;
        if (this.connection != null) {
            l = this.connection.directorySize(bl);
        }
        return l;
    }

    public long lastModified() throws Exception {
        long l = -1L;
        if (this.connection != null) {
            l = this.connection.lastModified();
        }
        return l;
    }

    public boolean canRead() throws Exception {
        boolean bl = false;
        if (this.connection != null) {
            bl = this.connection.canRead();
        }
        return bl;
    }

    public boolean canWrite() throws Exception {
        boolean bl = false;
        if (this.connection != null) {
            bl = this.connection.canWrite();
        }
        return bl;
    }

    public boolean isHidden() throws Exception {
        boolean bl = false;
        if (this.connection != null) {
            bl = this.connection.isHidden();
        }
        return bl;
    }

    public boolean setReadable(boolean bl) throws  {
        boolean bl2 = true;
        try {
            this.connection.setReadable(bl);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        return bl2;
    }

    public boolean setWritable(boolean bl) throws  {
        boolean bl2 = true;
        try {
            this.connection.setWritable(bl);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        return bl2;
    }

    public boolean setHidden(boolean bl) throws  {
        boolean bl2 = true;
        try {
            this.connection.setHidden(bl);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        return bl2;
    }

    public boolean rename(String string) throws  {
        boolean bl = true;
        try {
            this.connection.rename(string);
            this.cache.remove(this.location);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

