/*
 * Decompiled with CFR 0.152.
 */
import com.mobilepostproduction.j2j.Core;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Font;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.Graphics;
import com.mobilepostproduction.j2j.javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.Image;

final class Renderer
extends GameCanvas
implements Runnable {
    static final int WHITE = 0;
    static final int RED = 1;
    static final int BLUE = 2;
    static final int GREEN = 3;
    static final int GRAY = 4;
    static final int BROWN = 5;
    static final int YELLOW = 6;
    static final int BLACK = 7;
    static final int NUM_COLOURS = 8;
    static final int[] colorTable = new int[]{0xFFFFFF, 0xFF0000, 255, 65280, 0x7F7F7F, 0x9F9F00, 0xFFFF00, 0};
    Font font = null;
    Image loadedSprite;
    String[] outputStrings = new String[20];
    CompassMIDlet theApp;
    GameClass game;
    Graphics gameCanvasGraphics;
    Image pImage;
    int bgColor = 0;
    static int B_W = 240;
    static int B_H = 320;
    static final int V_W = 65536;
    static final int V_SHIFT = 16;
    static final int BORDER = 4;
    static final int V_H = B_H * 65536 / B_W;
    static final int virtualPixelWidth = 65536 / B_W;
    static final int virtualScreenWidth = (B_W << 16) / B_W;
    static final int virtualScreenHeight = (B_H << 16) / B_W;
    static final int virtualBorder = 262144 / B_W;
    int physicalScreenWidth;
    static final int RTA_X = 0;
    static final int RTA_XC = 1;
    static final int RTA_XR = 2;
    static final int RTA_Y = 0;
    static final int RTA_YC = 4;
    static final int RTA_YB = 8;
    static final int RTA_YSB = 16;
    static final int RF_IIMAGE = 0;
    static final int RF_RESID = 1;
    static final int RF_IMAX = 64;
    Image[] RFIimage = new Image[64];
    int LoadedNotification;
    boolean anyKeyPressed = false;
    public boolean outline = false;
    public boolean flash = false;
    int subFontHeight = 0;
    Thread actionThread = null;

    Renderer(boolean suppress) {
        super(suppress);
        this.setFullScreenMode(true);
    }

    void Renderer_initClass(CompassMIDlet app) {
        this.theApp = app;
        this.game = this.theApp.game;
        this.setDisplay();
        this.gameCanvasGraphics = this.getGraphics();
        this.game = this.theApp.game;
    }

    void RenderPlayerPosition(int x, int y) {
        this.gameCanvasGraphics.setClip(0, 0, B_W, B_H);
        this.gameCanvasGraphics.setColor(0);
        this.gameCanvasGraphics.fillRect(0, 40, 30, 20);
        this.gameCanvasGraphics.setColor(0xFFFFFF);
        this.gameCanvasGraphics.drawString("" + x + "," + y, 0, 42, 0x10 | 4);
    }

    void setDisplay() {
        Core.getDisplay(this.theApp);
        Core.setCurrent(this);
        while (!this.isShown()) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {}
        }
    }

    void Renderer_DrawClippedIndexedBmp(int spr, int ImageL, int ImageT, int ImageW, int ImageH, int ImageIX, int ImageIY, boolean mirror) {
        Image pImage = this.RFIimage[spr];
        if (spr == 0) {
            return;
        }
        int ImageR = ImageL + ImageW;
        int ImageB = ImageT + ImageH;
        if (ImageR < 0 || ImageL >= B_W || ImageB < 0 || ImageT >= B_H) {
            return;
        }
        this.gameCanvasGraphics.drawRegion(this.RFIimage[spr], ImageIX, ImageIY, ImageW, ImageH, mirror ? 2 : 0, ImageL, ImageT, 20);
    }

    void Renderer_DrawBmp(int sprite, int ImageL, int ImageT) {
        this.gameCanvasGraphics.drawImage(this.RFIimage[sprite], ImageL, ImageT, 0);
    }

    void Renderer_DrawBmpVirtual(int sprite, int ImageL, int ImageT) {
        this.gameCanvasGraphics.drawImage(this.RFIimage[sprite], Renderer.convertToBuild(ImageL), Renderer.convertToBuild(ImageT), 0);
    }

    void drawImage(Image image, int x, int y, int anchor) {
        this.gameCanvasGraphics.drawImage(image, x, y, anchor);
    }

    void drawRegion(int sprite, int src_x, int src_y, int width, int height, int transform, int dest_x, int dest_y, int anchor) {
        this.gameCanvasGraphics.drawRegion(this.RFIimage[sprite], src_x, src_y, width, height, transform, dest_x, dest_y, anchor);
    }

    void Renderer_DrawText(String pStr, int Align, int colour, int X, int Y) {
        int stringWidth = this.Renderer_GetStringWidth(pStr);
        if ((Align & 2) != 0) {
            stringWidth = this.Renderer_GetStringWidth(pStr);
            X = B_W - stringWidth;
        }
        if ((Align & 1) != 0) {
            X = -1;
        }
        if ((Align & 4) != 0) {
            Y = B_H - Y >> 1;
        }
        if ((Align & 8) != 0) {
            Y = B_H - this.Renderer_GetFontHeight() * 3 / 2;
        }
        if ((Align & 0x10) != 0) {
            Y = B_H - (this.Renderer_GetFontHeight() << 1);
        }
        this.drawStringWithOutline(pStr, X, Y, this.gameCanvasGraphics, colour);
    }

    void Renderer_DrawTextVirtual(String pStr, int Align, int colour, int X, int Y) {
        this.Renderer_DrawText(pStr, Align, colour, Renderer.convertToBuild(X), Renderer.convertToBuild(Y));
    }

    int Renderer_CalcTextWH(String pStr, int MaxWidth) {
        int W;
        int H;
        int FontH = this.Renderer_GetFontHeightVirtual();
        int i = this.createSplitStrings(pStr, this.outputStrings, MaxWidth);
        if (i > 1) {
            H = FontH * i;
            W = MaxWidth;
        } else {
            H = FontH;
            W = Renderer.convertToVirtual(this.Renderer_GetStringWidth(pStr));
        }
        return W << 16 & 0xFFFF0000 | H & 0xFFFF;
    }

    int Renderer_GetSpriteWidthVirtual(int ResID) {
        return Renderer.convertToVirtual(this.RFIimage[ResID].getWidth());
    }

    int Renderer_GetSpriteHeightVirtual(int ResID) {
        return Renderer.convertToVirtual(this.RFIimage[ResID].getHeight());
    }

    int Renderer_GetSpriteWidth(int ResID) {
        return this.RFIimage[ResID].getWidth();
    }

    int Renderer_GetSpriteHeight(int ResID) {
        return this.RFIimage[ResID].getHeight();
    }

    void RFM_Open() {
        this.RFM_IEmptyLib();
        this.Renderer_FontOpen();
    }

    int RFM_ILoad(String filename) {
        Image pBrewRes = this.loadImage(filename);
        int Index = this.RFM_IFindSlot();
        this.RFIimage[Index] = pBrewRes;
        return Index;
    }

    int RFM_ILoadRAW(int width, int height, int palette, byte[] idata, byte[] pal, int trans, int imgStart) {
        this.create(width, height, palette, idata, pal, trans, imgStart);
        int Index = this.RFM_IFindSlot();
        this.RFIimage[Index] = this.loadedSprite;
        this.loadedSprite = null;
        return Index;
    }

    void RFM_IUnload(int ResID) {
        if (this.RFIimage[ResID] == null) {
            return;
        }
        this.RFIimage[ResID] = null;
    }

    int RFM_IFindSlot() {
        for (int Index = 1; Index < 64; ++Index) {
            if (this.RFIimage[Index] != null) continue;
            return Index;
        }
        return 65535;
    }

    void RFM_IEmptyLib() {
        int Index = 64;
        while (Index-- != 0) {
            this.RFIimage[Index] = null;
        }
    }

    int convertXToBuild(int x) {
        if (((x *= B_W) & 0x8000) != 0) {
            x += 65536;
        }
        return x >> 16;
    }

    int convertYToBuild(int y) {
        if (((y *= B_W) & 0x8000) != 0) {
            y += 65536;
        }
        return y >> 16;
    }

    static final int convertToBuild(int x) {
        if (((x *= B_W) & 0x8000) != 0) {
            x += 65536;
        }
        return x >> 16;
    }

    public void keyPressed(int keyCode) {
        if (this.game != null && keyCode != -10) {
            this.game.keyPressed(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        if (this.game != null) {
            this.game.keyReleased(keyCode);
        }
    }

    Image loadImage(String filename) {
        Image image = null;
        filename = filename + ".png";
        int size = this.theApp.fileLoad(filename, null, true, 0, 0);
        byte[] array = new byte[size];
        size = this.theApp.fileLoad(filename, array, false, size, 0);
        image = Image.createImage((byte[])array, (int)0, (int)array.length);
        array = null;
        return image;
    }

    boolean isGameScreenShown() {
        return this.isShown();
    }

    static final int convertToVirtual(int width) {
        int i = (width << 16) / B_W;
        return i;
    }

    void Renderer_ClearScreen() {
        this.gameCanvasGraphics.setColor(this.bgColor);
        this.gameCanvasGraphics.fillRect(0, 0, B_W, B_H);
    }

    void create(int width, int height, int paletteCount, byte[] idata, byte[] pal, int trans, int imgStart) {
        int[] transTable = new int[256];
        int palEnd = paletteCount * 3;
        int i = 0;
        int j = 0;
        i = 0;
        while (i < palEnd) {
            byte r = pal[i + 2];
            byte g2 = pal[i + 1];
            byte b = pal[i];
            if (r < -8 || r > -1 || g2 < 0 || g2 > 8 || b < -8 || b > -1) {
                transTable[j] = (r & 0xFF) << 16 | (g2 & 0xFF) << 8 | b & 0xFF | 0xFF000000;
            }
            i += 3;
            ++j;
        }
        int area = width * height;
        int[] rgb = new int[area];
        int x = 0;
        int y = 0;
        j = 0;
        i = imgStart;
        while (j < area) {
            int pixel;
            rgb[j] = pixel = transTable[idata[i] & 0xFF];
            if (this.game.map.currentBlockSprite != -1) {
                int nonEmptySpriteIndex = y / 32 * 8 + x / 32;
                int nonEmptySpriteMask = 1 << (nonEmptySpriteIndex & 0x1F);
                nonEmptySpriteIndex >>= 5;
                if ((pixel & 0xFF000000) != 0) {
                    int[] nArray = this.game.map.nonEmptyBlock[this.game.map.currentBlockSprite];
                    int n = nonEmptySpriteIndex;
                    nArray[n] = nArray[n] | nonEmptySpriteMask;
                }
            }
            if (++x >= width) {
                x = 0;
                ++y;
            }
            ++j;
            ++i;
        }
        this.loadedSprite = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
    }

    void Renderer_DrawClippedIndexedBmpVirtual(int sprite, int ImageL, int ImageT, int ImageW, int ImageH, int ImageIX, int ImageIY, boolean mirror) {
        int IL = Renderer.convertToBuild(ImageL);
        int IT = Renderer.convertToBuild(ImageT);
        int IW = Renderer.convertToBuild(ImageW);
        int IH = Renderer.convertToBuild(ImageH);
        int IX = Renderer.convertToBuild(ImageIX);
        int IY = Renderer.convertToBuild(ImageIY);
        this.Renderer_DrawClippedIndexedBmp(sprite, IL, IT, IW, IH, IX, IY, mirror);
    }

    void Renderer_FillRect(int x, int y, int w, int h, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.fillRect(x, y, w, h);
    }

    void Renderer_FillTri(int x, int y, int x1, int y1, int x2, int y2, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.fillTriangle(x, y, x1, y1, x2, y2);
    }

    void Renderer_DrawLine(int x, int y, int x1, int y1, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.drawLine(x, y, x1, y1);
    }

    void Renderer_DrawLineVitual(int x, int y, int x1, int y1, int colour) {
        this.Renderer_DrawLine(Renderer.convertToBuild(x), Renderer.convertToBuild(y), Renderer.convertToBuild(x1), Renderer.convertToBuild(y1), colour);
    }

    void Renderer_DrawRect(int x, int y, int w, int h, int colour) {
        Graphics g2 = this.gameCanvasGraphics;
        g2.setColor(colour);
        g2.drawRect(x, y, w, h);
    }

    void Renderer_FillRectVirtual(int x, int y, int w, int h, int colour) {
        this.Renderer_FillRect(Renderer.convertToBuild(x), Renderer.convertToBuild(y), Renderer.convertToBuild(w), Renderer.convertToBuild(h), colour);
    }

    void Renderer_FillTriVirtual(int x, int y, int x1, int y1, int x2, int y2, int colour) {
        this.Renderer_FillTri(Renderer.convertToBuild(x), Renderer.convertToBuild(y), Renderer.convertToBuild(x1), Renderer.convertToBuild(y1), Renderer.convertToBuild(x2), Renderer.convertToBuild(y2), colour);
    }

    void Renderer_DrawRectVirtual(int x, int y, int w, int h, int colour) {
        this.Renderer_DrawRect(Renderer.convertToBuild(x), Renderer.convertToBuild(y), Renderer.convertToBuild(w), Renderer.convertToBuild(h), colour);
    }

    int Renderer_GetStringLength(String string) {
        int len = this.Renderer_GetStringWidth(string);
        len = Renderer.convertToVirtual(len);
        return len;
    }

    int Renderer_GetFontHeightVirtual() {
        return Renderer.convertToVirtual(this.Renderer_GetFontHeight());
    }

    int Renderer_GetFontHeight() {
        return this.font.getHeight();
    }

    void Renderer_FontOpen() {
        this.font = Font.getFont(0, 0, 0);
    }

    int Renderer_GetStringWidth(String pStr) {
        return this.font.stringWidth(pStr);
    }

    void Renderer_DrawChar(int x, int y, int chr, int colour, Graphics g2) {
        g2.setFont(this.font);
        g2.setColor(colorTable[colour]);
        g2.drawChar((char)chr, x, y, 4 | 0x10);
    }

    void drawStringWithOutline(String text, int x, int y, Graphics g2, int colour) {
        if (this.flash && (this.game.frameCounter & 8) == 0) {
            return;
        }
        if (colour > 8 || colour < 0) {
            colour = 0;
        }
        int clr = colorTable[colour];
        if (x == -1) {
            x = B_W - this.Renderer_GetStringWidth(text) >> 1;
        }
        g2.setFont(this.font);
        int l = text.indexOf(37);
        if (l >= 0) {
            text = text.replace('%', ':');
        }
        if (this.outline) {
            g2.setColor(0x550000);
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oy = -1; oy <= 1; ++oy) {
                    if ((ox | oy) == 0) continue;
                    g2.drawString(text, x + ox, y + oy, 4 | 0x10);
                }
            }
        }
        g2.setColor(clr);
        g2.drawString(text, x, y, 4 | 0x10);
    }

    int Renderer_GetCharWidth(int chr) {
        return this.font.charWidth((char)chr);
    }

    void Renderer_SetClipFullScreen() {
        this.gameCanvasGraphics.setClip(0, 0, B_W, B_H);
    }

    int Renderer_DrawTextMultipleVirtual(String pStr, int Align, int BGR0, int X, int Y, int maxWidth) {
        int y = this.Renderer_DrawTextMultiple(pStr, Align, BGR0, Renderer.convertToBuild(X), Renderer.convertToBuild(Y), Renderer.convertToBuild(maxWidth));
        return Renderer.convertToVirtual(y);
    }

    int Renderer_DrawTextMultiple(String pStr, int Align, int BGR0, int X, int Y, int maxWidth) {
        int fontHeight = this.Renderer_GetFontHeight();
        String[] strings = new String[20];
        int numStrings = this.createSplitStrings(pStr, strings, maxWidth);
        for (int i = 0; i < numStrings; ++i) {
            this.Renderer_DrawText(strings[i], Align, BGR0, X, Y);
            Y += fontHeight + 1 - this.subFontHeight;
        }
        strings = null;
        return Y;
    }

    int createSplitStrings(String text, String[] output, int maxWidth) {
        char currentChar = '\u0000';
        boolean endoftext = false;
        int numStrings = 0;
        int index = output.length;
        while (index-- != 0) {
            output[index] = null;
        }
        if (maxWidth == 0) {
            maxWidth = B_W;
        }
        while (!endoftext) {
            String tempString = "";
            int lastSpacePosition = 0;
            boolean endofline = false;
            for (index = 0; this.Renderer_GetStringWidth(tempString) < maxWidth && index < text.length() && !endofline; ++index) {
                currentChar = text.charAt(index);
                tempString = tempString + currentChar;
                if (currentChar == ' ' || currentChar == ':') {
                    lastSpacePosition = index;
                }
                if (currentChar != ':') continue;
                endofline = true;
            }
            if (lastSpacePosition == 0) {
                endofline = false;
                for (index = 0; index < tempString.length() && !endofline; ++index) {
                    currentChar = tempString.charAt(index);
                    if (currentChar != ':') continue;
                    lastSpacePosition = index;
                    endofline = true;
                }
            }
            if (index >= text.length()) {
                lastSpacePosition = text.length();
                endoftext = true;
            }
            tempString = tempString.substring(0, lastSpacePosition);
            if (!endoftext) {
                text = text.substring(lastSpacePosition + 1, text.length());
            }
            output[numStrings++] = tempString;
        }
        return numStrings;
    }

    void Renderer_Render() {
        this.gameCanvasGraphics.setColor(0);
        this.flushGraphics();
    }

    void Renderer_DrawSoftKeys(int keys, int color) {
        this.theApp.menu.Menu_SetupSoftKeys(keys);
        Menu cfr_ignored_0 = this.theApp.menu;
        int i = 30;
        while (true) {
            Menu cfr_ignored_1 = this.theApp.menu;
            if (i > 31) break;
            if (this.theApp.menu.Menu_Strings[i] != null) {
                int TextAlign = 0;
                Menu cfr_ignored_2 = this.theApp.menu;
                if ((this.theApp.menu.Menu_flags[i] & 0x8000) != 0) {
                    TextAlign = 0;
                }
                Menu cfr_ignored_3 = this.theApp.menu;
                if ((this.theApp.menu.Menu_flags[i] & 0x10000) != 0) {
                    TextAlign = 2;
                }
                this.Renderer_DrawTextVirtual(this.theApp.menu.Menu_Strings[i], TextAlign, color, this.theApp.menu.Menu_x[i], this.theApp.menu.Menu_y[i] + 500);
            }
            ++i;
        }
    }

    public void beginLongOperation() {
        this.actionThread = new Thread(this);
        this.actionThread.start();
    }

    public void endLongOperation() {
        this.actionThread = null;
    }

    public void run() {
        StringBuffer loadingString = new StringBuffer(this.game.gameStrings[77] + "...");
        int step = 2;
        Thread currentThread = Thread.currentThread();
        while (currentThread == this.actionThread) {
            if (step == 2) {
                step = 0;
                loadingString.delete(loadingString.length() - 2, loadingString.length());
            } else {
                ++step;
                loadingString.append('.');
            }
            this.bgColor = 0;
            this.Renderer_ClearScreen();
            this.Renderer_DrawText(loadingString.toString(), 5, 0xFFFFFF, 0, 0);
            this.Renderer_Render();
        }
    }
}

