/*
 * Decompiled with CFR 0.152.
 */
package toneoflove;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import toneoflove.Config;
import toneoflove.Element;
import toneoflove.GameDisplayable;
import toneoflove.Koordinate;
import toneoflove.ToneOfLove;

public class Playfield {
    public static Element[][] elements;
    private Element actualElement;
    public Image bgImage;
    public boolean initComplete;
    private int movingElementNumber = 0;
    private int appearXIndex;
    private int appearYIndex;
    private int handX = 0;
    private int handY = 0;

    public Playfield(Image im, int width, int height) {
        int ex = 3;
        int ey = 3;
        Element.WIDTH = Config.ELEMENTDIMENSIONX;
        Element.HEIGHT = Config.ELEMENTDIMENSIONY;
        elements = new Element[ex][ey];
        this.bgImage = im;
        Image[] images = this.getImages(im, ex, ey);
        int x = 0;
        int y = 0;
        int xStart = 0;
        int yStart = -Config.ELEMENTDIMENSIONY;
        int sollnumber = 0;
        for (int j = 0; j < ey; ++j) {
            for (int i = 0; i < ex; ++i) {
                Playfield.elements[i][j] = new Element(images[++sollnumber - 1], x, y, xStart, yStart, sollnumber);
                x += Element.WIDTH;
                xStart += Element.WIDTH;
                yStart -= Element.HEIGHT / 2;
            }
            x = 0;
            xStart = 0;
            y += Element.HEIGHT;
        }
    }

    public void fillElements(Graphics g, int state) {
        this.initComplete = true;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                try {
                    boolean result = elements[i][j].moveDown(Config.ELEMENTDIMENSIONY / 5, state, 10);
                    if (result) {
                        this.initComplete = false;
                    }
                    elements[i][j].paint(g);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void removeElements(Graphics g) {
        this.initComplete = true;
        boolean result = true;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                result = elements[i][j].moveDown(Config.ELEMENTDIMENSIONY / 5, GameDisplayable.COMPLETE, this.movingElementNumber);
                if (result) {
                    this.initComplete = false;
                }
                elements[i][j].paint(g);
            }
        }
        ++this.movingElementNumber;
    }

    public boolean completeAnimation() {
        return this.initComplete;
    }

    public Image[] getImages(Image largeImage, int nrImgsHorizontal, int nrImgsVertical) {
        Image[] smallImages = new Image[nrImgsHorizontal * nrImgsVertical];
        int smallImageWidth = Element.WIDTH;
        int smallImageHeight = Element.HEIGHT;
        int num = 0;
        for (int i = 0; i < nrImgsVertical; ++i) {
            for (int j = 0; j < nrImgsHorizontal; ++j) {
                smallImages[num] = Image.createImage((int)smallImageWidth, (int)smallImageHeight);
                Graphics g = smallImages[num].getGraphics();
                g.setClip(0, 0, smallImageWidth, smallImageHeight);
                if (largeImage != null) {
                    g.drawImage(largeImage, -(j * smallImageWidth), -(i * smallImageHeight), 0);
                } else {
                    g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i))).append("/").append(j))), 0, 0, 20);
                }
                ++num;
            }
        }
        return smallImages;
    }

    public void paint(Graphics g) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                try {
                    elements[i][j].paint(g);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean solved() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!elements[i][j].isHidden()) continue;
                return false;
            }
        }
        return true;
    }

    public void reset() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                elements[i][j].resetPos();
            }
        }
        this.movingElementNumber = 0;
    }

    public void disappear() {
        if (this.actualElement != null) {
            this.actualElement.setAppear(false);
        }
    }

    public boolean isHidden(int i, int j) {
        return elements[i][j].isHidden();
    }

    public void appear(Koordinate k) {
        if (this.actualElement != null) {
            this.actualElement.setAppear(false);
        }
        this.appearXIndex = k.x;
        this.appearYIndex = k.y;
        elements[k.x][k.y].setAppear(true);
        this.actualElement = elements[k.x][k.y];
    }

    public void hit(int i, int j) {
        Koordinate k = new Koordinate(i, j);
        this.appear(k);
        boolean result = ToneOfLove.gameDisplayable.melody.recal(k);
        if (result) {
            Config.soundAppear(i + j * 3);
        } else {
            Config.soundFalse();
            ToneOfLove.gameDisplayable.state = GameDisplayable.COMPLETE;
            ToneOfLove.gameDisplayable.startThread();
        }
    }
}

