/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class Container
extends Component {
    private static boolean enableLayoutOnPaint = true;
    private Component leadComponent;
    private Layout layout;
    private Vector components = new Vector();
    private boolean shouldLayout = true;
    boolean scrollableX;
    boolean scrollableY;
    private Vector cmpTransitions;
    private int scrollIncrement = 20;
    private boolean blockFocus = false;

    public Container(Layout layout) {
        this.setUIID("Container");
        this.layout = layout;
        this.setFocusable(false);
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(lookAndFeel.isDefaultSmoothScrolling());
    }

    public Container() {
        this(new FlowLayout());
    }

    public void setLeadComponent(Component component) {
        this.leadComponent = component;
        if (this.isInitialized()) {
            this.initLead();
        }
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        if (this.leadComponent != null) {
            this.setFocusLead(true);
        }
    }

    void focusLostInternal() {
        super.focusLostInternal();
        if (this.leadComponent != null) {
            this.setFocusLead(false);
        }
    }

    public Component getLeadComponent() {
        if (this.leadComponent != null) {
            return this.leadComponent;
        }
        if (this.hasLead) {
            return super.getLeadComponent();
        }
        return null;
    }

    public Container getLeadParent() {
        if (this.leadComponent != null) {
            return this;
        }
        if (this.hasLead) {
            return this.getParent().getLeadParent();
        }
        return null;
    }

    private void initLead() {
        this.disableFocusAndInitLead(this);
        this.setFocusable(true);
        this.hasLead = true;
    }

    public void keyPressed(int n) {
        if (this.leadComponent != null) {
            this.leadComponent.keyPressed(n);
            this.repaint();
        }
    }

    public void keyReleased(int n) {
        if (this.leadComponent != null) {
            this.leadComponent.keyReleased(n);
            this.repaint();
        }
    }

    private void disableFocusAndInitLead(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponentAt(i);
            if (component instanceof Container) {
                this.disableFocusAndInitLead((Container)component);
            }
            component.setFocusable(false);
            component.hasLead = true;
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void invalidate() {
        this.setShouldCalcPreferredSize(true);
    }

    protected void setShouldLayout(boolean bl) {
        if (!this.shouldCalcScrollSize) {
            this.shouldCalcScrollSize = bl;
        }
        if (this.shouldLayout != bl) {
            this.shouldLayout = bl;
            this.shouldCalcPreferredSize = bl;
            this.shouldCalcScrollSize = bl;
            Container container = this.getParent();
            if (container != null) {
                container.setShouldLayout(bl);
            }
        }
    }

    public void setShouldCalcPreferredSize(boolean bl) {
        Form form;
        super.setShouldCalcPreferredSize(bl);
        this.shouldLayout = bl;
        if (this.shouldLayout) {
            int n = this.components.size();
            for (int i = 0; i < n; ++i) {
                Component component = (Component)this.components.elementAt(i);
                if (!(component instanceof Container)) continue;
                ((Container)component).setShouldCalcPreferredSize(bl);
            }
        }
        if ((form = this.getComponentForm()) != null) {
            form.clearFocusVectors();
        }
    }

    public int getLayoutWidth() {
        if (this.isScrollableX()) {
            return Math.max(this.getWidth(), this.getPreferredW());
        }
        Container container = this.getScrollableParent();
        if (container != null && container.isScrollableX()) {
            return Math.max(this.getWidth(), this.getPreferredW());
        }
        int n = this.getWidth();
        if (n <= 0) {
            return this.getPreferredW();
        }
        return n;
    }

    public int getLayoutHeight() {
        if (this.isScrollableY()) {
            return Math.max(this.getHeight(), this.getPreferredH());
        }
        Container container = this.getScrollableParent();
        if (container != null && container.isScrollableY()) {
            return Math.max(this.getHeight(), this.getPreferredH());
        }
        int n = this.getHeight();
        if (n <= 1) {
            return this.getPreferredH();
        }
        return n;
    }

    public void applyRTL(boolean bl) {
        this.setRTL(bl);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponentAt(i);
            if (component instanceof Container) {
                ((Container)component).applyRTL(bl);
                continue;
            }
            component.setRTL(bl);
        }
    }

    private Container getScrollableParent() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!container.isScrollable()) continue;
            return container;
        }
        return null;
    }

    public void addComponent(Component component) {
        this.layout.addLayoutComponent(null, component, this);
        this.insertComponentAt(this.components.size(), component);
    }

    public void addComponent(Object object, Component component) {
        this.layout.addLayoutComponent(object, component, this);
        this.insertComponentAt(this.components.size(), component);
    }

    public void addComponent(int n, Object object, Component component) {
        this.layout.addLayoutComponent(object, component, this);
        this.insertComponentAt(n, component);
    }

    private void insertComponentAt(int n, Component component) {
        if (component.getParent() != null) {
            throw new IllegalArgumentException("Component is already contained in Container: " + component.getParent());
        }
        if (component instanceof Form) {
            throw new IllegalArgumentException("A form cannot be added to a container");
        }
        component.setParent(this);
        this.components.insertElementAt(component, n);
        this.setShouldCalcPreferredSize(true);
        if (this.isInitialized()) {
            component.initComponentImpl();
        }
    }

    public void addComponent(int n, Component component) {
        this.layout.addLayoutComponent(null, component, this);
        this.insertComponentAt(n, component);
    }

    public void replaceAndWait(Component component, Component component2, Transition transition) {
        this.replaceComponents(component, component2, transition, true);
    }

    public void replace(Component component, Component component2, Transition transition) {
        this.replaceComponents(component, component2, transition, false);
    }

    private void replaceComponents(Component component, Component component2, Transition transition, boolean bl) {
        if (!this.contains(component)) {
            throw new IllegalArgumentException("Component " + component + " is not contained in this Container");
        }
        if (transition == null || !this.isVisible() || this.getComponentForm() == null) {
            this.replace(component, component2);
            return;
        }
        this.setScrollX(0);
        this.setScrollY(0);
        component2.setX(component.getX());
        component2.setY(component.getY());
        component2.setWidth(component.getWidth());
        component2.setHeight(component.getHeight());
        component2.setParent(this);
        if (component2 instanceof Container) {
            ((Container)component2).layoutContainer();
        }
        Anim anim = new Anim(this, component, component2, transition);
        this.getComponentForm().registerAnimatedInternal(anim);
        if (bl) {
            Display.getInstance().invokeAndBlock(anim);
        }
    }

    private boolean isParentOf(Component component) {
        if ((component = component.getParent()) == null || component instanceof Form) {
            return false;
        }
        return component == this || this.isParentOf(component);
    }

    private boolean requestFocusChild() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponentAt(i);
            if (component.isFocusable()) {
                component.requestFocus();
                return true;
            }
            if (!(component instanceof Container) || !((Container)component).requestFocusChild()) continue;
            return true;
        }
        return false;
    }

    void replace(Component component, Component component2) {
        Object object;
        int n = this.components.indexOf(component);
        boolean bl = false;
        if (component.getComponentForm() != null) {
            object = component.getComponentForm().getFocused();
            boolean bl2 = bl = object == component;
            if (!bl && component instanceof Container && object != null && ((Container)component).isParentOf((Component)object)) {
                bl = true;
            }
        }
        if ((object = this.layout.getComponentConstraint(component)) != null) {
            this.removeComponentImpl(component);
            this.layout.addLayoutComponent(object, component2, this);
        } else {
            this.removeComponentImpl(component);
        }
        component2.setParent(null);
        if (n < 0) {
            n = 0;
        }
        this.insertComponentAt(n, component2);
        if (bl) {
            if (component2.isFocusable()) {
                component2.requestFocus();
            } else if (component2 instanceof Container) {
                ((Container)component2).requestFocusChild();
            }
        }
    }

    void initComponentImpl() {
        if (!this.isInitialized()) {
            super.initComponentImpl();
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            ((Component)this.components.elementAt(i)).initComponentImpl();
        }
        if (this.leadComponent != null) {
            this.initLead();
        }
    }

    public boolean isEnabled() {
        if (this.leadComponent != null) {
            return this.leadComponent.isEnabled();
        }
        return super.isEnabled();
    }

    public void removeComponent(Component component) {
        this.removeComponentImpl(component);
    }

    void removeComponentImpl(Component component) {
        Form form = component.getComponentForm();
        this.layout.removeLayoutComponent(component);
        component.deinitializeImpl();
        this.components.removeElement(component);
        component.setParent(null);
        if (form != null) {
            if (form.getFocused() == component || component instanceof Container && ((Container)component).contains(form.getFocused())) {
                form.setFocused(null);
            }
            if (component.isSmoothScrolling()) {
                form.deregisterAnimatedInternal(component);
            }
        }
        this.setShouldCalcPreferredSize(true);
    }

    void deinitializeImpl() {
        super.deinitializeImpl();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            ((Component)this.components.elementAt(i)).deinitializeImpl();
        }
        this.flushReplace();
    }

    public void flushReplace() {
        if (this.cmpTransitions != null) {
            int n = this.cmpTransitions.size();
            for (int i = 0; i < n; ++i) {
                ((Anim)this.cmpTransitions.elementAt(i)).destroy();
            }
            this.cmpTransitions.removeAllElements();
            this.cmpTransitions = null;
        }
    }

    public void removeAll() {
        Object[] objectArray;
        Form form = this.getComponentForm();
        if (form != null && (objectArray = form.getFocused()) != null && this.contains((Component)objectArray)) {
            form.setFocused(null);
        }
        objectArray = new Object[this.components.size()];
        this.components.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.removeComponent((Component)objectArray[i]);
        }
    }

    public void revalidate() {
        this.setShouldCalcPreferredSize(true);
        Form form = this.getComponentForm();
        if (form != null) {
            form.layoutContainer();
            form.repaint();
        } else {
            this.layoutContainer();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        int n;
        if (enableLayoutOnPaint) {
            this.layoutContainer();
        }
        graphics.translate(this.getX(), this.getY());
        int n2 = this.components.size();
        LWUITImplementation lWUITImplementation = Display.getInstance().getImplementation();
        for (n = 0; n < n2; ++n) {
            Component component = (Component)this.components.elementAt(n);
            component.paintInternal(lWUITImplementation.getComponentScreenGraphics(this, graphics), false);
        }
        n = graphics.getTranslateX();
        int n3 = graphics.getTranslateY();
        graphics.translate(-n, -n3);
        this.paintGlass(graphics);
        graphics.translate(n, n3);
        graphics.translate(-this.getX(), -this.getY());
    }

    void paintGlassImpl(Graphics graphics) {
        super.paintGlassImpl(graphics);
        int n = graphics.getTranslateX();
        int n2 = graphics.getTranslateY();
        graphics.translate(-n, -n2);
        this.paintGlass(graphics);
        graphics.translate(n, n2);
    }

    protected void paintGlass(Graphics graphics) {
    }

    void paintIntersecting(Graphics graphics, Component component, int n, int n2, int n3, int n4, boolean bl) {
        if (this.layout.isOverlapSupported() && this.components.contains(component)) {
            int n5;
            int n6;
            int n7 = this.components.indexOf(component);
            if (bl) {
                n6 = n7 + 1;
                n5 = this.components.size();
            } else {
                n6 = 0;
                n5 = n7;
            }
            for (int i = n6; i < n5; ++i) {
                Component component2 = (Component)this.components.elementAt(i);
                if (!Rectangle.intersects(n, n2, n3, n4, component2.getAbsoluteX() + component2.getScrollX(), component2.getAbsoluteY() + component2.getScrollY(), component2.getBounds().getSize().getWidth(), component2.getBounds().getSize().getHeight())) continue;
                component2.paintInternal(graphics, false);
            }
        }
    }

    public void layoutContainer() {
        if (this.shouldLayout) {
            this.shouldLayout = false;
            this.doLayout();
        }
    }

    void doLayout() {
        this.layout.layoutContainer(this);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponentAt(i);
            if (component instanceof Container) {
                ((Container)component).layoutContainer();
                continue;
            }
            component.laidOut();
        }
        this.laidOut();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public Component getComponentAt(int n) {
        return (Component)this.components.elementAt(n);
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = this.getComponentAt(i);
            if (!component2.equals(component)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Component component) {
        boolean bl = false;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = this.getComponentAt(i);
            if (component2.equals(component)) {
                return true;
            }
            if (!(component2 instanceof Container) || !(bl = ((Container)component2).contains(component))) continue;
            return true;
        }
        return false;
    }

    protected void scrollComponentToVisible(Component component) {
        if (this.isScrollable() && component != null) {
            Form form;
            Rectangle rectangle = component.getVisibleBounds();
            if (component.getParent() != null && (form = this.getComponentForm()) != null && form.getFocusPosition(component) == 0 && rectangle == component.getBounds()) {
                this.scrollRectToVisible(new Rectangle(0, 0, component.getX() + Math.min(component.getWidth(), this.getWidth()), component.getY() + Math.min(component.getHeight(), this.getHeight())), this);
                return;
            }
            this.scrollRectToVisible(rectangle.getX(), rectangle.getY(), Math.min(rectangle.getSize().getWidth(), this.getWidth()), Math.min(rectangle.getSize().getHeight(), this.getHeight()), component);
        }
    }

    boolean moveScrollTowards(int n, Component component) {
        if (this.isScrollable()) {
            boolean bl;
            Component component2 = null;
            Form form = this.getComponentForm();
            component2 = form.getFocused();
            int n2 = form.getFocusPosition(component2);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n3 = this.getScrollX();
            int n4 = this.getScrollY();
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            switch (n) {
                case 1: {
                    n4 = this.getScrollY() - this.scrollIncrement;
                    bl2 = n2 == 0;
                    bl3 = component2 != null && component2.getVisibleBounds().getSize().getHeight() > this.getHeight();
                    boolean bl5 = bl4 = n4 < 0;
                    if (!bl4) break;
                    n4 = 0;
                    break;
                }
                case 6: {
                    n4 = this.getScrollY() + this.scrollIncrement;
                    bl2 = n2 == form.getFocusCount() - 1;
                    bl3 = component2 != null && component2.getVisibleBounds().getSize().getHeight() > this.getHeight();
                    boolean bl6 = bl4 = n4 > this.getScrollDimension().getHeight() - this.getHeight();
                    if (!bl4) break;
                    n4 = this.getScrollDimension().getHeight() - this.getHeight();
                    break;
                }
                case 5: {
                    n3 = this.getScrollX() + this.scrollIncrement;
                    bl2 = n2 == form.getFocusCount() - 1;
                    bl3 = component2 != null && component2.getVisibleBounds().getSize().getWidth() > this.getWidth();
                    boolean bl7 = bl4 = n3 > this.getScrollDimension().getWidth() - this.getWidth();
                    if (!bl4) break;
                    n3 = this.getScrollDimension().getWidth() - this.getWidth();
                    break;
                }
                case 2: {
                    n3 = this.getScrollX() - this.scrollIncrement;
                    bl2 = n2 == 0;
                    bl3 = component2 != null && component2.getVisibleBounds().getSize().getWidth() > this.getWidth();
                    boolean bl8 = bl4 = n3 < 0;
                    if (!bl4) break;
                    n3 = 0;
                }
            }
            if (component == null || component == this) {
                this.scrollRectToVisible(n3, n4, n5, n6, this);
                return false;
            }
            boolean bl9 = bl = this.contains(component) && Rectangle.intersects(component.getAbsoluteX(), component.getAbsoluteY(), component.getWidth(), component.getHeight(), this.getAbsoluteX() + n3, this.getAbsoluteY() + n4, n5, n6);
            if (bl && !bl3 && !bl2 || Rectangle.contains(this.getAbsoluteX() + this.getScrollX(), this.getAbsoluteY() + this.getScrollY(), n5, n6, component.getAbsoluteX(), component.getAbsoluteY(), component.getWidth(), component.getHeight())) {
                return true;
            }
            if (!bl4) {
                this.scrollRectToVisible(n3, n4, n5, n6, this);
                return bl && !Rectangle.intersects(component2.getAbsoluteX(), component2.getAbsoluteY(), component2.getWidth(), component2.getHeight(), this.getAbsoluteX() + n3, this.getAbsoluteY() + n4, n5, n6);
            }
            return true;
        }
        return true;
    }

    public Component getComponentAt(int n, int n2) {
        int n3 = this.getComponentCount();
        boolean bl = this.getLayout().isOverlapSupported();
        Component component = null;
        for (int i = n3 - 1; i >= 0; --i) {
            Component component2 = this.getComponentAt(i);
            if (!component2.contains(n, n2)) continue;
            component = component2;
            if (!bl && component.isFocusable()) {
                return component;
            }
            if (component2 instanceof Container) {
                component = ((Container)component2).getComponentAt(n, n2);
            }
            if (bl && !component.isFocusable() && !component.isGrabsPointerEvents()) continue;
            return component;
        }
        if (component != null) {
            return component;
        }
        if (this.contains(n, n2)) {
            return this;
        }
        return null;
    }

    public void pointerHover(int[] nArray, int[] nArray2) {
        Component component;
        if (!this.isDragActivated() && (component = this.getComponentAt(nArray[0], nArray2[0])) != null && component.isFocusable()) {
            component.requestFocus();
        }
        super.pointerDragged(nArray[0], nArray2[0]);
    }

    public void pointerPressed(int n, int n2) {
        this.clearDrag();
        this.setDragActivated(false);
        Component component = this.getComponentAt(n, n2);
        if (component == this) {
            super.pointerPressed(n, n2);
        } else if (component != null) {
            component.pointerPressed(n, n2);
        }
    }

    protected Dimension calcPreferredSize() {
        Dimension dimension = this.layout.getPreferredSize(this);
        Style style = this.getStyle();
        if (style.getBorder() != null && dimension.getWidth() != 0 && dimension.getHeight() != 0) {
            dimension.setWidth(Math.max(style.getBorder().getMinimumWidth(), dimension.getWidth()));
            dimension.setHeight(Math.max(style.getBorder().getMinimumHeight(), dimension.getHeight()));
        }
        return dimension;
    }

    protected String paramString() {
        String string = this.layout.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        return super.paramString() + ", layout = " + string2 + ", scrollableX = " + this.scrollableX + ", scrollableY = " + this.scrollableY + ", components = " + this.getComponentsNames();
    }

    private String getComponentsNames() {
        String string = "[";
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.components.elementAt(i).getClass().getName();
            string = string + string2.substring(string2.lastIndexOf(46) + 1) + ", ";
        }
        if (string.length() > 1) {
            string = string.substring(0, string.length() - 2);
        }
        string = string + "]";
        return string;
    }

    public void refreshTheme() {
        super.refreshTheme();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            Component component = (Component)this.components.elementAt(i);
            component.refreshTheme();
        }
    }

    public boolean isScrollableX() {
        return this.scrollableX && (this.getScrollDimension().getWidth() > this.getWidth() || this.isAlwaysTensile());
    }

    public boolean isScrollableY() {
        return this.scrollableY && (this.getScrollDimension().getHeight() > this.getHeight() || this.isAlwaysTensile());
    }

    public void setScrollableX(boolean bl) {
        this.scrollableX = bl;
    }

    public void setScrollableY(boolean bl) {
        this.scrollableY = bl;
    }

    public void setScrollable(boolean bl) {
        this.setScrollableX(bl);
        this.setScrollableY(bl);
    }

    public void setCellRenderer(boolean bl) {
        if (this.isCellRenderer() != bl) {
            super.setCellRenderer(bl);
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.getComponentAt(i).setCellRenderer(bl);
            }
        }
    }

    public void setScrollIncrement(int n) {
        this.scrollIncrement = n;
    }

    public int getScrollIncrement() {
        return this.scrollIncrement;
    }

    public Component findFirstFocusable() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component;
            Component component2 = this.getComponentAt(i);
            if (component2.isFocusable()) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = ((Container)component2).findFirstFocusable()) == null) continue;
            return component;
        }
        return null;
    }

    private void setFocusLead(boolean bl) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponentAt(i);
            if (component instanceof Container) {
                ((Container)component).setFocusLead(bl);
            }
            component.setFocus(bl);
            if (bl) {
                component.fireFocusGained();
                continue;
            }
            component.fireFocusLost();
        }
    }

    protected void dragInitiated() {
        super.dragInitiated();
        if (this.leadComponent != null) {
            this.leadComponent.dragInitiated();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponentAt(i);
            component.setEnabled(bl);
        }
    }

    protected int getGridPosY() {
        int n = this.getScrollY();
        int n2 = this.getComponentCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Component component = this.getComponentAt(i);
            int n4 = component.getY();
            if (Math.abs(n - n4) >= Math.abs(n - n3)) continue;
            n3 = n4;
        }
        if (Math.abs(n - n3) > 2) {
            return n3;
        }
        return n;
    }

    private boolean shouldPaintContainerBackground() {
        Component component;
        Style style;
        if (this.getComponentCount() == 1 && (style = this.getStyle()).getPadding(0) == 0 && style.getPadding(2) == 0 && style.getPadding(1) == 0 && style.getPadding(3) == 0 && (component = this.getComponentAt(0)).getWidth() == this.getWidth() && component.getHeight() == this.getHeight()) {
            if (component.isFlatten() || (component.getStyle().getBgTransparency() & 0xFF) == 255) {
                return false;
            }
            if (component instanceof Container) {
                return ((Container)component).shouldPaintContainerBackground();
            }
        }
        return true;
    }

    public void paintBackground(Graphics graphics) {
        if (this.isFlatten()) {
            super.paintBackgrounds(graphics);
            return;
        }
        if (this.shouldPaintContainerBackground()) {
            super.paintBackground(graphics);
        }
    }

    protected int getGridPosX() {
        int n = this.getScrollX();
        int n2 = this.getComponentCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Component component = this.getComponentAt(i);
            int n4 = component.getX();
            if (Math.abs(n - n4) >= Math.abs(n - n3)) continue;
            n3 = n4;
        }
        if (Math.abs(n - n3) > 2) {
            return n3;
        }
        return n;
    }

    void setBlockFocus(boolean bl) {
        this.blockFocus = bl;
    }

    boolean isBlockFocus() {
        return this.blockFocus;
    }

    public void animateLayoutAndWait(int n) {
        this.animateLayout(n, true);
    }

    public void animateLayout(int n) {
        this.animateLayout(n, false);
    }

    private void animateLayout(int n, boolean bl) {
        Component component;
        int n2;
        enableLayoutOnPaint = false;
        int n3 = this.getComponentCount();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        Motion[] motionArray = new Motion[n3];
        Motion[] motionArray2 = new Motion[n3];
        Motion[] motionArray3 = new Motion[n3];
        Motion[] motionArray4 = new Motion[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            component = this.getComponentAt(n2);
            nArray[n2] = component.getX();
            nArray2[n2] = component.getY();
            nArray3[n2] = component.getWidth();
            nArray4[n2] = component.getHeight();
        }
        this.layoutContainer();
        for (n2 = 0; n2 < n3; ++n2) {
            component = this.getComponentAt(n2);
            motionArray[n2] = Motion.createSplineMotion(nArray[n2], component.getX(), n);
            motionArray2[n2] = Motion.createSplineMotion(nArray2[n2], component.getY(), n);
            motionArray3[n2] = Motion.createSplineMotion(nArray3[n2], component.getWidth(), n);
            motionArray4[n2] = Motion.createSplineMotion(nArray4[n2], component.getHeight(), n);
            motionArray[n2].start();
            motionArray2[n2].start();
            motionArray3[n2].start();
            motionArray4[n2].start();
            component.setX(nArray[n2]);
            component.setY(nArray2[n2]);
            component.setWidth(nArray3[n2]);
            component.setHeight(nArray4[n2]);
        }
        Anim anim = new Anim(this, n, new Motion[][]{motionArray, motionArray2, motionArray3, motionArray4});
        this.getComponentForm().registerAnimated(anim);
        if (bl) {
            Display.getInstance().invokeAndBlock(anim);
        }
    }

    static class Anim
    implements Animation,
    Runnable {
        private int animationType;
        private long startTime;
        private int duration;
        private Transition t;
        private Component current;
        private Component next;
        private boolean started = false;
        private Container thisContainer;
        private boolean finished = false;
        private Form parent;
        private Motion[][] motions;

        public Anim(Container container, int n, Motion[][] motionArray) {
            this.startTime = System.currentTimeMillis();
            this.animationType = 2;
            this.duration = n;
            this.thisContainer = container;
            this.motions = motionArray;
        }

        public Anim(Container container, Component component, Component component2, Transition transition) {
            this.animationType = 1;
            this.t = transition;
            this.next = component2;
            this.current = component;
            this.thisContainer = container;
            this.parent = container.getComponentForm();
        }

        public boolean animate() {
            boolean bl;
            switch (this.animationType) {
                case 2: {
                    if (System.currentTimeMillis() - this.startTime >= (long)this.duration) {
                        enableLayoutOnPaint = true;
                        this.thisContainer.getComponentForm().deregisterAnimated(this);
                        this.thisContainer.getComponentForm().revalidate();
                        return false;
                    }
                    int n = this.thisContainer.getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        Component component = this.thisContainer.getComponentAt(i);
                        component.setX(this.motions[0][i].getValue());
                        component.setY(this.motions[1][i].getValue());
                        component.setWidth(this.motions[2][i].getValue());
                        component.setHeight(this.motions[3][i].getValue());
                    }
                    this.thisContainer.repaint();
                    return false;
                }
            }
            if (!this.started) {
                this.t.init(this.current, this.next);
                this.t.initTransition();
                this.started = true;
                if (this.thisContainer.cmpTransitions == null) {
                    this.thisContainer.cmpTransitions = new Vector();
                }
                this.thisContainer.cmpTransitions.addElement(this);
            }
            if (!(bl = this.t.animate())) {
                this.thisContainer.cmpTransitions.removeElement(this);
                this.destroy();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            this.parent.deregisterAnimatedInternal(this);
            this.next.setParent(null);
            this.thisContainer.replace(this.current, this.next);
            this.t.cleanup();
            if (this.thisContainer.cmpTransitions.size() == 0) {
                this.parent.revalidate();
            }
            this.finished = true;
            Anim anim = this;
            synchronized (anim) {
                this.notify();
            }
        }

        public void paint(Graphics graphics) {
            this.t.paint(graphics);
        }

        public boolean isFinished() {
            return this.finished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isFinished()) {
                try {
                    Anim anim = this;
                    synchronized (anim) {
                        this.wait(50L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

