/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.MenuBar;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class Dialog
extends Form {
    private boolean disposed;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_ALARM = 1;
    public static final int TYPE_CONFIRMATION = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_INFO = 4;
    public static final int TYPE_WARNING = 5;
    private long time;
    private Command lastCommandPressed;
    private boolean menu;
    private int dialogType;
    private int top = -1;
    private int bottom;
    private int left;
    private int right;
    private boolean includeTitle;
    private String position;
    private static boolean dialogTitleCompatibilityMode;
    private static boolean autoAdjustDialogSize;
    private static String defaultDialogPosition;
    private String dialogPosition = defaultDialogPosition;
    private static boolean disableStaticDialogScrolling;
    private boolean autoDispose = true;
    private boolean modal = true;
    private Command[] buttonCommands;
    private static int defaultDialogType;
    private static boolean commandsAsButtons;
    private boolean disposeWhenPointerOutOfBounds = false;
    private Label dialogTitle;
    private Container dialogContentPane;

    public static boolean isDialogTitleCompatibilityMode() {
        return dialogTitleCompatibilityMode;
    }

    public static void setDialogTitleCompatibilityMode(boolean bl) {
        dialogTitleCompatibilityMode = bl;
    }

    public Dialog(String string) {
        this();
        this.setTitle(string);
    }

    public Dialog() {
        this("Dialog", "DialogTitle");
    }

    Dialog(String string, String string2) {
        if (dialogTitleCompatibilityMode) {
            this.getContentPane().setUIID(string);
            this.getTitleComponent().setUIID(string2);
        } else {
            super.getContentPane().setUIID(string);
            super.getTitleComponent().setText("");
            super.getTitleComponent().setVisible(false);
            this.titleArea.setVisible(false);
            this.dialogContentPane = new Container();
            this.dialogContentPane.setUIID("DialogContentPane");
            this.dialogTitle = new Label("", string2);
            super.getContentPane().setLayout(new BorderLayout());
            super.getContentPane().addComponent("North", (Component)this.dialogTitle);
            super.getContentPane().addComponent("Center", (Component)this.dialogContentPane);
            super.getContentPane().setScrollable(false);
        }
        super.getStyle().setBgTransparency(0);
        super.getStyle().setBgImage(null);
        this.setSmoothScrolling(false);
        this.deregisterAnimated(this);
    }

    public Container getContentPane() {
        if (dialogTitleCompatibilityMode) {
            return super.getContentPane();
        }
        return this.dialogContentPane;
    }

    public Layout getLayout() {
        if (dialogTitleCompatibilityMode) {
            return super.getLayout();
        }
        return this.dialogContentPane.getLayout();
    }

    public String getTitle() {
        if (dialogTitleCompatibilityMode) {
            return super.getTitle();
        }
        return this.dialogTitle.getText();
    }

    public void addComponent(Component component) {
        if (dialogTitleCompatibilityMode) {
            super.addComponent(component);
            return;
        }
        this.dialogContentPane.addComponent(component);
    }

    public void addComponent(Object object, Component component) {
        if (dialogTitleCompatibilityMode) {
            super.addComponent(object, component);
            return;
        }
        this.dialogContentPane.addComponent(object, component);
    }

    public void addComponent(int n, Object object, Component component) {
        if (dialogTitleCompatibilityMode) {
            super.addComponent(n, object, component);
            return;
        }
        this.dialogContentPane.addComponent(n, object, component);
    }

    public void addComponent(int n, Component component) {
        if (dialogTitleCompatibilityMode) {
            super.addComponent(n, component);
            return;
        }
        this.dialogContentPane.addComponent(n, component);
    }

    public void removeAll() {
        if (dialogTitleCompatibilityMode) {
            super.removeAll();
            return;
        }
        this.dialogContentPane.removeAll();
    }

    public void removeComponent(Component component) {
        if (dialogTitleCompatibilityMode) {
            super.removeComponent(component);
            return;
        }
        this.dialogContentPane.removeComponent(component);
    }

    public Label getTitleComponent() {
        if (dialogTitleCompatibilityMode) {
            return super.getTitleComponent();
        }
        return this.dialogTitle;
    }

    public Style getTitleStyle() {
        if (dialogTitleCompatibilityMode) {
            return super.getTitleStyle();
        }
        return this.dialogTitle.getStyle();
    }

    public void setLayout(Layout layout) {
        if (dialogTitleCompatibilityMode) {
            super.setLayout(layout);
            return;
        }
        this.dialogContentPane.setLayout(layout);
    }

    public void setTitle(String string) {
        if (dialogTitleCompatibilityMode) {
            this.setTitle(string);
            return;
        }
        this.dialogTitle.setText(string);
    }

    public void setTitleComponent(Label label) {
        if (dialogTitleCompatibilityMode) {
            super.setTitleComponent(label);
            return;
        }
        super.getContentPane().removeComponent(this.dialogTitle);
        this.dialogTitle = label;
        super.getContentPane().addComponent("North", (Component)this.dialogTitle);
    }

    public Container getDialogComponent() {
        return super.getContentPane();
    }

    public void setTitleComponent(Label label, Transition transition) {
        if (dialogTitleCompatibilityMode) {
            super.setTitleComponent(label, transition);
            return;
        }
        super.getContentPane().replace(this.dialogTitle, label, transition);
        this.dialogTitle = label;
    }

    public void setDialogStyle(Style style) {
        super.getContentPane().setUnselectedStyle(style);
    }

    public void setDialogUIID(String string) {
        super.getContentPane().setUIID(string);
    }

    public String getDialogUIID() {
        return super.getContentPane().getUIID();
    }

    public Style getDialogStyle() {
        return super.getContentPane().getStyle();
    }

    void initLaf(LookAndFeel lookAndFeel) {
        this.setTransitionOutAnimator(lookAndFeel.getDefaultDialogTransitionOut());
        this.setTransitionInAnimator(lookAndFeel.getDefaultDialogTransitionIn());
    }

    public Command show(int n, int n2, int n3, int n4, boolean bl) {
        return this.show(n, n2, n3, n4, bl, true);
    }

    public Command show(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.top = n;
        this.bottom = n2;
        if (this.isRTL()) {
            this.left = n4;
            this.right = n3;
        } else {
            this.left = n3;
            this.right = n4;
        }
        this.includeTitle = bl;
        this.setDisposed(false);
        this.modal = bl2;
        this.lastCommandPressed = null;
        this.showModal(this.top, this.bottom, this.left, this.right, bl, bl2, false);
        return this.lastCommandPressed;
    }

    public void setTimeout(long l) {
        this.time = System.currentTimeMillis() + l;
        super.registerAnimatedInternal(this);
    }

    public static boolean show(String string, String string2, int n, Image image, String string3, String string4) {
        return Dialog.show(string, string2, n, image, string3, string4, 0L);
    }

    void sizeChangedInternal(int n, int n2) {
        this.autoAdjust(n, n2);
        super.sizeChangedInternal(n, n2);
        Form form = this.getPreviousForm();
        if (form != null) {
            form.sizeChangedInternal(n, n2);
        }
    }

    protected void autoAdjust(int n, int n2) {
        if (autoAdjustDialogSize) {
            Container container = super.getContentPane();
            Label label = super.getTitleComponent();
            int n3 = container.getPreferredH();
            int n4 = container.getPreferredW();
            Style style = container.getStyle();
            Style style2 = label.getStyle();
            if (this.position != null) {
                int n5 = 0;
                if (this.getSoftButtonCount() > 1) {
                    Container container2 = this.getSoftButton(0).getParent();
                    Style style3 = container2.getStyle();
                    n5 = container2.getPreferredH() + style3.getMargin(false, 0) + style3.getMargin(false, 2);
                }
                n4 = Math.min(n4, n);
                n2 = n2 - n5 - label.getPreferredH();
                int n6 = Math.max(0, (n2 - n3) / 2);
                int n7 = Math.max(0, (n - n4) / 2);
                int n8 = n6;
                int n9 = n6;
                int n10 = n7;
                int n11 = n7;
                if (this.position.equals("East")) {
                    n10 = Math.max(0, n - n4);
                    n11 = 0;
                } else if (this.position.equals("West")) {
                    n11 = 0;
                    n10 = Math.max(0, n - n4);
                } else if (this.position.equals("North")) {
                    n8 = 0;
                    n9 = Math.max(0, n2 - n3);
                } else if (this.position.equals("South")) {
                    n8 = Math.max(0, n2 - n3);
                    n9 = 0;
                }
                if (this.includeTitle) {
                    style2.setMargin(0, n8, true);
                    style2.setMargin(2, 0, true);
                    style2.setMargin(1, n10, true);
                    style2.setMargin(3, n11, true);
                    style.setMargin(0, 0, true);
                    style.setMargin(2, n9, true);
                    style.setMargin(1, n10, true);
                    style.setMargin(3, n11, true);
                    style.setPadding(0, 0, 0, 0);
                } else {
                    style2.setMargin(0, 0, true);
                    style2.setMargin(2, 0, true);
                    style2.setMargin(1, 0, true);
                    style2.setMargin(3, 0, true);
                    style.setPadding(0, 0, 0, 0);
                    style.setMargin(0, n8, true);
                    style.setMargin(2, n9, true);
                    style.setMargin(1, n10, true);
                    style.setMargin(3, n11, true);
                }
                return;
            }
            int n12 = this.getWidth();
            int n13 = this.getHeight();
            if (n12 != n || n13 != n2) {
                if (n4 <= n && n3 <= n2) {
                    float f = (float)this.left / ((float)this.left + (float)this.right);
                    float f2 = (float)this.top / ((float)this.top + (float)this.bottom);
                    this.top = Math.max(0, (int)((float)(n2 - n3) * f2));
                    this.left = Math.max(0, (int)((float)(n - n4) * f));
                    this.bottom = Math.max(0, n2 - n3 - this.top);
                    this.right = Math.max(0, n - n4 - this.left);
                    if (this.includeTitle) {
                        style2.setMargin(0, this.top, true);
                        style2.setMargin(2, 0, true);
                        style2.setMargin(1, this.left, true);
                        style2.setMargin(3, this.right, true);
                        style.setMargin(0, 0, true);
                        style.setMargin(2, this.bottom, true);
                        style.setMargin(1, this.left, true);
                        style.setMargin(3, this.right, true);
                        style.setPadding(0, 0, 0, 0);
                    } else {
                        style2.setMargin(0, 0, true);
                        style2.setMargin(2, 0, true);
                        style2.setMargin(1, 0, true);
                        style2.setMargin(3, 0, true);
                        style.setPadding(0, 0, 0, 0);
                        style.setMargin(0, this.top, true);
                        style.setMargin(2, this.bottom, true);
                        style.setMargin(1, this.left, true);
                        style.setMargin(3, this.right, true);
                    }
                    return;
                }
                float f = (float)n / (float)n12;
                float f3 = (float)n2 / (float)n13;
                Style style4 = this.getDialogStyle();
                style4.setMargin(0, (int)((float)style4.getMargin(false, 0) * f3));
                style4.setMargin(2, (int)((float)style4.getMargin(false, 2) * f3));
                style4.setMargin(1, (int)((float)style4.getMargin(this.isRTL(), 1) * f));
                style4.setMargin(3, (int)((float)style4.getMargin(this.isRTL(), 3) * f));
                style2.setMargin(0, (int)((float)style2.getMargin(false, 0) * f3));
                style2.setMargin(1, (int)((float)style2.getMargin(this.isRTL(), 1) * f));
                style2.setMargin(3, (int)((float)style2.getMargin(this.isRTL(), 3) * f));
                return;
            }
        }
    }

    public static boolean show(String string, String string2, int n, Image image, String string3, String string4, long l) {
        Command command = new Command(string3);
        Command[] commandArray = string4 != null ? new Command[]{new Command(string4), command} : new Command[]{command};
        return Dialog.show(string, string2, command, commandArray, n, image, l) == command;
    }

    public static Command show(String string, String string2, Command[] commandArray, int n, Image image, long l) {
        return Dialog.show(string, string2, null, commandArray, n, image, l);
    }

    public static Command show(String string, String string2, Command command, Command[] commandArray, int n, Image image, long l) {
        return Dialog.show(string, string2, command, commandArray, n, image, l, null);
    }

    public static Command show(String string, String string2, Command[] commandArray, int n, Image image, long l, Transition transition) {
        return Dialog.show(string, string2, null, commandArray, n, image, l, transition);
    }

    public static Command show(String string, String string2, Command command, Command[] commandArray, int n, Image image, long l, Transition transition) {
        Object object;
        Hashtable hashtable = UIManager.getInstance().getResourceBundle();
        if (hashtable != null && string2 != null && (object = hashtable.get(string2)) != null) {
            string2 = (String)object;
        }
        object = new TextArea(string2, 3, 30);
        ((Component)object).setUIID("DialogBody");
        ((TextArea)object).setEditable(false);
        return Dialog.show(string, (Component)object, command, commandArray, n, image, l, transition);
    }

    public static boolean show(String string, String string2, String string3, String string4) {
        return Dialog.show(string, string2, defaultDialogType, null, string3, string4);
    }

    public static Command show(String string, Component component, Command[] commandArray) {
        return Dialog.show(string, component, commandArray, defaultDialogType, null);
    }

    public static Command show(String string, Component component, Command[] commandArray, int n, Image image) {
        return Dialog.show(string, component, commandArray, n, image, 0L);
    }

    public static Command show(String string, Component component, Command[] commandArray, int n, Image image, long l) {
        return Dialog.show(string, component, commandArray, n, image, l, null);
    }

    public static Command show(String string, Component component, Command[] commandArray, int n, Image image, long l, Transition transition) {
        return Dialog.show(string, component, null, commandArray, n, image, l, transition);
    }

    private void addButtonBar(Container container) {
        super.getContentPane().addComponent("South", (Component)container);
    }

    public void placeButtonCommands(Command[] commandArray) {
        this.buttonCommands = commandArray;
        Container container = new Container(new FlowLayout(4));
        container.setUIID("DialogCommandArea");
        if (dialogTitleCompatibilityMode) {
            this.addComponent("South", (Component)container);
        } else {
            this.addButtonBar(container);
        }
        if (commandArray.length > 0) {
            int n;
            int n2 = Integer.parseInt(UIManager.getInstance().getThemeConstant("dlgCommandButtonSizeInt", "0"));
            for (n = 0; n < commandArray.length; ++n) {
                Button button = new Button(commandArray[n]);
                n2 = Math.max(button.getPreferredW(), n2);
                container.addComponent(button);
            }
            for (n = 0; n < commandArray.length; ++n) {
                container.getComponentAt(n).setPreferredW(n2);
            }
            container.getComponentAt(0).requestFocus();
        }
    }

    public void keyReleased(int n) {
        if (commandsAsButtons) {
            if (MenuBar.isLSK(n)) {
                if (this.buttonCommands != null && this.buttonCommands.length > 0) {
                    this.dispatchCommand(this.buttonCommands[0], new ActionEvent(this.buttonCommands[0]));
                }
                return;
            }
            if (MenuBar.isRSK(n)) {
                if (this.buttonCommands != null && this.buttonCommands.length > 1) {
                    this.dispatchCommand(this.buttonCommands[1], new ActionEvent(this.buttonCommands[1]));
                }
                return;
            }
        }
        super.keyReleased(n);
    }

    public static Command show(String string, Component component, Command command, Command[] commandArray, int n, Image image, long l, Transition transition) {
        Dialog dialog = new Dialog(string);
        dialog.dialogType = n;
        dialog.setTransitionInAnimator(transition);
        dialog.setTransitionOutAnimator(transition);
        dialog.lastCommandPressed = null;
        dialog.setLayout(new BorderLayout());
        if (commandArray != null) {
            if (commandsAsButtons) {
                dialog.placeButtonCommands(commandArray);
            } else {
                for (int i = 0; i < commandArray.length; ++i) {
                    dialog.addCommand(commandArray[i]);
                }
            }
            if (commandArray.length == 1) {
                dialog.setBackCommand(commandArray[0]);
            } else if (commandArray.length == 2) {
                dialog.setBackCommand(commandArray[1]);
            }
        }
        if (command != null) {
            dialog.setDefaultCommand(command);
        }
        dialog.addComponent("Center", component);
        if (image != null) {
            dialog.addComponent("East", (Component)new Label(image));
        }
        if (l != 0L) {
            dialog.setTimeout(l);
        }
        if (component.isScrollable() || disableStaticDialogScrolling) {
            dialog.setScrollable(false);
        }
        dialog.show();
        return dialog.lastCommandPressed;
    }

    protected void onShow() {
        if (this.dialogType > 0) {
            Display.getInstance().playDialogSound(this.dialogType);
        }
    }

    public void showBack() {
        this.showImpl(true);
    }

    public void show() {
        this.showImpl(false);
    }

    private void showImpl(boolean bl) {
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, this.modal);
        } else if (this.modal) {
            if (this.getDialogPosition() == null) {
                super.showModal(bl);
            } else {
                this.showPacked(this.getDialogPosition(), true);
            }
        } else {
            this.showModeless();
        }
    }

    public void showModeless() {
        this.modal = false;
        this.setDisposed(false);
        if (this.top > -1) {
            this.show(this.top, this.bottom, this.left, this.right, this.includeTitle, false);
        } else if (this.getDialogPosition() == null) {
            this.showDialog(false, false);
        } else {
            this.showPacked(this.getDialogPosition(), false);
        }
    }

    void showModal(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        if (!dialogTitleCompatibilityMode && this.dialogTitle != null && UIManager.getInstance().isThemeConstant("hideEmptyTitleBool", false)) {
            this.dialogTitle.setVisible(this.dialogTitle.getText().length() > 0);
        }
        super.showModal(n, n2, n3, n4, bl, bl2, bl3);
    }

    public Command showPacked(String string, boolean bl) {
        this.position = string;
        int n = Display.getInstance().getDisplayHeight();
        int n2 = Display.getInstance().getDisplayWidth();
        if (this.top > -1) {
            this.refreshTheme();
        }
        Container container = super.getContentPane();
        Label label = super.getTitleComponent();
        if (!dialogTitleCompatibilityMode && this.dialogTitle != null && UIManager.getInstance().isThemeConstant("hideEmptyTitleBool", false)) {
            this.getTitleComponent().setVisible(label.getText().length() > 0);
        }
        Style style = this.getDialogStyle();
        int n3 = 0;
        if (this.getSoftButtonCount() > 1) {
            Container container2 = this.getSoftButton(0).getParent();
            Style style2 = container2.getStyle();
            n3 = container2.getPreferredH() + style2.getMargin(false, 0) + style2.getMargin(false, 2);
        }
        this.revalidate();
        int n4 = container.getPreferredH();
        int n5 = container.getPreferredW();
        n5 = Math.min(n5, n2);
        if (style.getBorder() != null) {
            n5 = Math.max(style.getBorder().getMinimumWidth(), n5);
            n4 = Math.max(style.getBorder().getMinimumHeight(), n4);
        }
        n = n - n3 - label.getPreferredH();
        int n6 = Math.max(0, (n - n4) / 2);
        int n7 = Math.max(0, (n2 - n5) / 2);
        if (string.equals("Center")) {
            this.show(n6, n6, n7, n7, true, bl);
            return this.lastCommandPressed;
        }
        if (string.equals("East")) {
            this.show(n6, n6, Math.max(0, n2 - n5), 0, true, bl);
            return this.lastCommandPressed;
        }
        if (string.equals("West")) {
            this.show(n6, n6, 0, Math.max(0, n2 - n5), true, bl);
            return this.lastCommandPressed;
        }
        if (string.equals("North")) {
            this.show(0, Math.max(0, n - n4), n7, n7, true, bl);
            return this.lastCommandPressed;
        }
        if (string.equals("South")) {
            this.show(Math.max(0, n - n4), 0, n7, n7, true, bl);
            return this.lastCommandPressed;
        }
        throw new IllegalArgumentException("Unknown position: " + string);
    }

    public void dispose() {
        this.setDisposed(true);
        if (!this.menu) {
            super.dispose();
        }
    }

    public Command showDialog() {
        this.lastCommandPressed = null;
        this.show();
        return this.lastCommandPressed;
    }

    protected void actionCommand(Command command) {
        if (!this.autoDispose || this.lastCommandPressed == null) {
            this.lastCommandPressed = command;
        }
        if (this.menu || this.autoDispose && command.isDisposesDialog()) {
            this.dispose();
        }
    }

    public boolean animate() {
        this.isTimedOut();
        return false;
    }

    private boolean isTimedOut() {
        if (this.time != 0L && System.currentTimeMillis() >= this.time) {
            this.time = 0L;
            this.dispose();
            this.deregisterAnimatedInternal(this);
            return true;
        }
        return false;
    }

    boolean isMenu() {
        return this.menu;
    }

    void setMenu(boolean bl) {
        this.menu = bl;
    }

    void addSelectCommand() {
        if (!this.menu) {
            this.getMenuBar().addSelectCommand(this.getSelectCommandText());
        }
    }

    boolean isDisposed() {
        return this.disposed || this.isTimedOut();
    }

    void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean bl) {
        this.autoDispose = bl;
    }

    public static void setDefaultDialogPosition(String string) {
        defaultDialogPosition = string;
    }

    public static String getDefaultDialogPosition() {
        return defaultDialogPosition;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int n) {
        this.dialogType = n;
    }

    public static void setDefaultDialogType(int n) {
        defaultDialogType = n;
    }

    public static int getDefaultDialogType() {
        return defaultDialogType;
    }

    public static void setAutoAdjustDialogSize(boolean bl) {
        autoAdjustDialogSize = bl;
    }

    public static void setDisableStaticDialogScrolling(boolean bl) {
        disableStaticDialogScrolling = bl;
    }

    public static boolean isDisableStaticDialogScrolling() {
        return disableStaticDialogScrolling;
    }

    public static void setCommandsAsButtons(boolean bl) {
        commandsAsButtons = bl;
    }

    public static boolean isCommandsAsButtons() {
        return commandsAsButtons;
    }

    public void setDisposeWhenPointerOutOfBounds(boolean bl) {
        this.disposeWhenPointerOutOfBounds = bl;
    }

    public boolean isDisposeWhenPointerOutOfBounds() {
        return this.disposeWhenPointerOutOfBounds;
    }

    public void pointerReleased(int n, int n2) {
        super.pointerReleased(n, n2);
        if (this.disposeWhenPointerOutOfBounds && !this.getTitleComponent().contains(n, n2) && !this.getContentPane().contains(n, n2) && !this.getMenuBar().contains(n, n2)) {
            this.dispose();
        }
    }

    public String getDialogPosition() {
        return this.dialogPosition;
    }

    public void setDialogPosition(String string) {
        this.dialogPosition = string;
    }

    static {
        autoAdjustDialogSize = true;
        defaultDialogType = 4;
    }
}

