/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.CustomFont;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class Font {
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FACE_SYSTEM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int STYLE_PLAIN = 0;
    private static Font defaultFont = new Font(null);
    private static Hashtable bitmapCache = new Hashtable();
    private static boolean enableBitmapFont = true;
    private Object font;

    Font() {
    }

    Font(Object object) {
        this.font = object;
    }

    Font(int n, int n2, int n3) {
        this.font = Display.getInstance().getImplementation().createFont(n, n2, n3);
    }

    public static Font getBitmapFont(String string) {
        return (Font)bitmapCache.get(string);
    }

    public static void clearBitmapCache() {
        bitmapCache.clear();
    }

    public static boolean isTrueTypeFileSupported() {
        return Display.getInstance().getImplementation().isTrueTypeSupported();
    }

    public static boolean isCreationByStringSupported() {
        return Display.getInstance().getImplementation().isLookupFontSupported();
    }

    public static Font createTrueTypeFont(InputStream inputStream) throws IOException {
        return new Font(Display.getInstance().getImplementation().loadTrueTypeFont(inputStream));
    }

    public static Font create(String string) {
        return new Font(Display.getInstance().getImplementation().loadNativeFont(string));
    }

    public void addContrast(byte by) {
    }

    public static Font createBitmapFont(String string, Image image, int[] nArray, int[] nArray2, String string2) {
        Font font = Font.createBitmapFont(image, nArray, nArray2, string2);
        bitmapCache.put(string, font);
        return font;
    }

    public static Font createBitmapFont(Image image, int[] nArray, int[] nArray2, String string) {
        return new CustomFont(image, nArray, nArray2, string);
    }

    public static Font createSystemFont(int n, int n2, int n3) {
        return new Font(n, n2, n3);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return Display.getInstance().getImplementation().charsWidth(this.font, cArray, n, n2);
    }

    public int substringWidth(String string, int n, int n2) {
        return Display.getInstance().getImplementation().stringWidth(this.font, string.substring(n, n + n2));
    }

    public int stringWidth(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return Display.getInstance().getImplementation().stringWidth(this.font, string);
    }

    public int charWidth(char c) {
        return Display.getInstance().getImplementation().charWidth(this.font, c);
    }

    public int getHeight() {
        return Display.getInstance().getImplementation().getHeight(this.font);
    }

    void drawChar(Graphics graphics, char c, int n, int n2) {
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font font) {
        if (font != null) {
            defaultFont = font;
        }
    }

    void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
    }

    public int getFace() {
        return Display.getInstance().getImplementation().getFace(this.font);
    }

    public int getSize() {
        return Display.getInstance().getImplementation().getSize(this.font);
    }

    public int getStyle() {
        return Display.getInstance().getImplementation().getStyle(this.font);
    }

    public String getCharset() {
        return null;
    }

    public static void setBitmapFontEnabled(boolean bl) {
        enableBitmapFont = bl;
    }

    public static boolean isBitmapFontEnabled() {
        return enableBitmapFont;
    }

    public Object getNativeFont() {
        return this.font;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Font font = (Font)object;
            return font.getFace() == this.getFace() && font.getSize() == this.getSize() && font.getStyle() == this.getStyle();
        }
        return false;
    }
}

