/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IndexedImage
extends Image {
    private int width;
    private int height;
    byte[] imageDataByte;
    int[] palette;
    static int[] lineCache;

    public IndexedImage(int n, int n2, int[] nArray, byte[] byArray) {
        super(null);
        this.width = n;
        this.height = n2;
        this.palette = nArray;
        this.imageDataByte = byArray;
        this.initOpaque();
    }

    private void initOpaque() {
        if (this.palette != null) {
            for (int i = 0; i < this.palette.length; ++i) {
                if ((this.palette[i] & 0xFF000000) == -16777216) continue;
                this.setOpaque(false);
                return;
            }
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
    }

    private IndexedImage(int n, int n2, int[] nArray, int[] nArray2) {
        super(null);
        this.width = n;
        this.height = n2;
        this.palette = nArray;
        this.imageDataByte = new byte[n * n2];
        for (int i = 0; i < this.imageDataByte.length; ++i) {
            this.imageDataByte[i] = (byte)this.paletteOffset(nArray2[i]);
        }
        this.initOpaque();
    }

    private int paletteOffset(int n) {
        for (int i = 0; i < this.palette.length; ++i) {
            if (n != this.palette[i]) continue;
            return i;
        }
        throw new IllegalStateException("Invalid palette request in paletteOffset");
    }

    public static Image pack(String string) throws IOException {
        return IndexedImage.pack(Image.createImage(string));
    }

    public Image subImage(int n, int n2, int n3, int n4, boolean bl) {
        byte[] byArray = new byte[n3 * n4];
        for (int i = 0; i < byArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3;
            int n7 = n + n6 + (n2 + n5) * this.width;
            byArray[i] = this.imageDataByte[n7];
        }
        return new IndexedImage(n3, n4, this.palette, byArray);
    }

    public Image rotate(int n) {
        throw new RuntimeException("The rotate method is not supported by indexed images at the moment");
    }

    public Image modifyAlpha(byte by) {
        int[] nArray = new int[this.palette.length];
        System.arraycopy(this.palette, 0, nArray, 0, this.palette.length);
        int n = by << 24 & 0xFF000000;
        for (int i = 0; i < this.palette.length; ++i) {
            if ((this.palette[i] & 0xFF000000) == 0) continue;
            nArray[i] = this.palette[i] & 0xFFFFFF | n;
        }
        return new IndexedImage(this.width, this.height, nArray, this.imageDataByte);
    }

    public Graphics getGraphics() {
        throw new RuntimeException("Indexed image objects are immutable");
    }

    void getRGB(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 * this.width + n2;
        for (int i = 0; i < n5; ++i) {
            int n7 = i * n4;
            for (int j = 0; j < n4; ++j) {
                int n8 = this.imageDataByte[n6 + j] & 0xFF;
                nArray[n + n7 + j] = this.palette[n8];
            }
            n6 += this.width;
        }
    }

    public static IndexedImage pack(int[] nArray, int n, int n2) {
        int n3 = n * n2;
        int[] nArray2 = new int[256];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = nArray[i];
            if (IndexedImage.contains(nArray2, n4, n5)) continue;
            if (n4 > 255) {
                return null;
            }
            nArray2[n4] = n5;
            ++n4;
        }
        if (n4 != nArray2.length) {
            int[] nArray3 = new int[n4];
            System.arraycopy(nArray2, 0, nArray3, 0, n4);
            nArray2 = nArray3;
        }
        IndexedImage indexedImage = new IndexedImage(n, n2, nArray2, nArray);
        return indexedImage;
    }

    public static Image pack(Image image) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray = image.getRGBCached();
        IndexedImage indexedImage = IndexedImage.pack(nArray, n, n2);
        if (indexedImage == null) {
            return image;
        }
        return indexedImage;
    }

    private static boolean contains(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != n2) continue;
            return true;
        }
        return false;
    }

    protected void drawImage(Graphics graphics, Object object, int n, int n2) {
        if (lineCache == null || lineCache.length < this.width * 3) {
            lineCache = new int[this.width * 3];
        }
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipHeight() + n3;
        int n5 = 0;
        int n6 = this.height;
        if (n3 > n2) {
            n5 = n3 - n2;
        }
        if (n4 < n2 + this.height) {
            n6 = n4 - n2;
        }
        for (int i = n5; i < n6; i += 3) {
            int n7 = i * this.width;
            int n8 = Math.min(3, this.height - i);
            int n9 = this.width * n8;
            for (int j = 0; j < n9; ++j) {
                int n10 = this.imageDataByte[j + n7] & 0xFF;
                IndexedImage.lineCache[j] = this.palette[n10];
            }
            graphics.drawRGB(lineCache, 0, n, n2 + i, this.width, n8, true);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void scale(int n, int n2) {
        IndexedImage indexedImage = (IndexedImage)this.scaled(n, n2);
        this.imageDataByte = indexedImage.imageDataByte;
        this.width = n;
        this.height = n2;
    }

    public Image scaled(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n3 == n && n4 == n2) {
            return this;
        }
        Dimension dimension = new Dimension(n, n2);
        Image image = this.getCachedImage(dimension);
        image = new IndexedImage(n, n2, this.palette, this.scaleArray(this.imageDataByte, n, n2));
        this.cacheImage(dimension, image);
        return image;
    }

    byte[] scaleArray(byte[] byArray, int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n3 == n && n4 == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n * n2];
        int n5 = (n4 << 16) / n2;
        int n6 = (n3 << 16) / n;
        int n7 = n6 / 2;
        int n8 = n5 / 2;
        for (int i = 0; i < n; ++i) {
            int n9 = n7 >> 16;
            for (int j = 0; j < n2; ++j) {
                int n10 = n8 >> 16;
                int n11 = i + j * n;
                int n12 = n9 + n10 * n3;
                if (n11 >= 0 && n11 < byArray2.length && n12 >= 0 && n12 < byArray.length) {
                    byArray2[n11] = byArray[n12];
                }
                n8 += n5;
            }
            n8 = n5 / 2;
            n7 += n6;
        }
        return byArray2;
    }

    int[] getRGBImpl() {
        int[] nArray = new int[this.width * this.height];
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.imageDataByte[i] & 0xFF;
            nArray[i] = this.palette[n];
        }
        return nArray;
    }

    public final int[] getPalette() {
        return this.palette;
    }

    public final byte[] getImageDataByte() {
        return this.imageDataByte;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(this.width);
            dataOutputStream.writeShort(this.height);
            dataOutputStream.writeByte(this.palette.length);
            for (int i = 0; i < this.palette.length; ++i) {
                dataOutputStream.writeInt(this.palette[i]);
            }
            dataOutputStream.write(this.imageDataByte);
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static IndexedImage load(byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            int[] nArray = new int[dataInputStream.readByte() & 0xFF];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            byte[] byArray2 = new byte[s * s2];
            dataInputStream.readFully(byArray2);
            return new IndexedImage((int)s, (int)s2, nArray, byArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

