/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.LWUITImplementation;

public class MediaComponent
extends Component {
    private Object player;
    private Object vidc;
    private boolean fullscreen = false;

    public MediaComponent(Object object) {
        this.player = object;
        this.setFocusable(false);
        this.vidc = Display.getInstance().getImplementation().createVideoComponent(object);
    }

    protected void initComponent() {
        this.getComponentForm().registerMediaComponent(this);
    }

    protected void deinitialize() {
        this.getComponentForm().deregisterMediaComponent(this);
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            Display.getInstance().getImplementation().paintVideo(this, this.fullscreen, graphics.getGraphics(), this.vidc, this.player);
        }
    }

    protected void paintBackground(Graphics graphics) {
    }

    public void paintBackgrounds(Graphics graphics) {
    }

    protected Dimension calcPreferredSize() {
        LWUITImplementation lWUITImplementation = Display.getInstance().getImplementation();
        return new Dimension(lWUITImplementation.getVideoWidth(this.vidc), lWUITImplementation.getVideoHeight(this.vidc));
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.vidc != null) {
            Display.getInstance().getImplementation().setVideoVisible(this.vidc, bl);
        }
    }

    public void start() {
        Display.getInstance().getImplementation().startVideo(this.player, this.vidc);
    }

    public void stop() {
        Display.getInstance().getImplementation().stopVideo(this.player, this.vidc);
    }

    public void setLoopCount(int n) {
        Display.getInstance().getImplementation().setVideoLoopCount(this.player, n);
    }

    public long getMediaTime() {
        return Display.getInstance().getImplementation().getMediaTime(this.player);
    }

    public long setMediaTime(long l) {
        return Display.getInstance().getImplementation().setMediaTime(this.player, l);
    }

    public void setFullScreen(boolean bl) {
        this.fullscreen = bl;
        this.repaint();
    }

    public boolean isFullScreen() {
        return this.fullscreen;
    }

    public Object getVideoControl() {
        return this.vidc;
    }
}

