/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;

public class RGBImage
extends Image {
    private int width;
    private int height;
    private int[] rgb;
    private boolean opaque;

    public RGBImage(Image image) {
        super(null);
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.rgb = image.getRGBCached();
    }

    public RGBImage(int[] nArray, int n, int n2) {
        super(null);
        this.width = n;
        this.height = n2;
        this.rgb = nArray;
    }

    public Image subImage(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = new int[n3 * n4];
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3;
            int n7 = n + n6 + (n2 + n5) * this.width;
            nArray[i] = this.rgb[n7];
        }
        return new RGBImage(nArray, n3, n4);
    }

    public Image scaled(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n3 == n && n4 == n2) {
            return this;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n * n2];
        this.scaleArray(n3, n4, n2, n, nArray, nArray2);
        return new RGBImage(nArray2, n, n2);
    }

    public void scale(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n3 == n && n4 == n2) {
            return;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n * n2];
        this.scaleArray(n3, n4, n2, n, nArray, nArray2);
        this.width = n;
        this.height = n2;
        this.rgb = nArray2;
    }

    public Image rotate(int n) {
        throw new RuntimeException("The rotate method is not supported by RGB images at the moment");
    }

    public Image modifyAlpha(byte by) {
        int[] nArray = new int[this.rgb.length];
        System.arraycopy(this.rgb, 0, nArray, 0, this.rgb.length);
        int n = by << 24 & 0xFF000000;
        for (int i = 0; i < this.rgb.length; ++i) {
            if ((nArray[i] & 0xFF000000) == 0) continue;
            nArray[i] = nArray[i] & 0xFFFFFF | n;
        }
        return new RGBImage(nArray, this.width, this.height);
    }

    public Graphics getGraphics() {
        throw new RuntimeException("RGBImage objects can't be modified via graphics");
    }

    public int[] getRGB() {
        return this.rgb;
    }

    void getRGB(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 * this.width + n2;
        for (int i = 0; i < n5; ++i) {
            int n7 = i * n4;
            for (int j = 0; j < n4; ++j) {
                nArray[n + n7 + j] = this.rgb[n6 + j];
            }
            n6 += this.width;
        }
    }

    protected void drawImage(Graphics graphics, Object object, int n, int n2) {
        graphics.drawRGB(this.rgb, 0, n, n2, this.width, this.height, !this.opaque);
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

