/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.midp;

import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.impl.midp.GameCanvasImplementation;
import com.sun.lwuit.util.Resources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m2g.ExternalResourceHandler;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImplementation
extends GameCanvasImplementation {
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private int id = 0;
    private static int idCounter = 0;

    public void getRGB(Object object, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        if (object instanceof ScalableImage) {
            ScalableImage scalableImage = (ScalableImage)object;
            ScalableGraphics scalableGraphics = ScalableGraphics.createInstance();
            int n6 = this.getImageWidth(object);
            int n7 = this.getImageHeight(object);
            javax.microedition.lcdui.Image image = javax.microedition.lcdui.Image.createImage((int)n6, (int)n7);
            Graphics graphics = image.getGraphics();
            scalableGraphics.bindTarget((Object)graphics);
            scalableGraphics.render(0, 0, scalableImage);
            scalableGraphics.releaseTarget();
            image.getRGB(nArray, n, n4, n2, n3, n4, n5);
        } else {
            super.getRGB(object, nArray, n, n2, n3, n4, n5);
        }
    }

    public Object scale(Object object, int n, int n2) {
        if (object instanceof ScalableImage) {
            ScalableImage scalableImage = (ScalableImage)object;
            scalableImage.setViewportWidth(n);
            scalableImage.setViewportHeight(n2);
            return scalableImage;
        }
        return super.scale(object, n, n2);
    }

    public boolean isOpaque(Image image, Object object) {
        if (object instanceof ScalableImage) {
            return false;
        }
        return super.isOpaque(image, object);
    }

    public int getImageWidth(Object object) {
        if (object instanceof ScalableImage) {
            return ((ScalableImage)object).getViewportWidth();
        }
        return super.getImageWidth(object);
    }

    public int getImageHeight(Object object) {
        if (object instanceof ScalableImage) {
            return ((ScalableImage)object).getViewportHeight();
        }
        return super.getImageHeight(object);
    }

    public boolean animateImage(Object object, long l) {
        if (object instanceof SVGImage) {
            SVGImage sVGImage = (SVGImage)object;
            long l2 = System.currentTimeMillis();
            sVGImage.incrementTime((float)(l2 - l) / 1000.0f);
            return true;
        }
        return false;
    }

    public void drawImage(Object object, Object object2, int n, int n2) {
        if (object2 instanceof SVGImage) {
            ScalableGraphics scalableGraphics = ScalableGraphics.createInstance();
            Graphics graphics = (Graphics)object;
            graphics.setClip(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
            scalableGraphics.bindTarget((Object)graphics);
            scalableGraphics.render(n, n2, (ScalableImage)((SVGImage)object2));
            scalableGraphics.releaseTarget();
        } else {
            super.drawImage(object, object2, n, n2);
        }
    }

    public Object getSVGDocument(Object object) {
        return this.getSVGElement((SVGImage)object);
    }

    private SVGSVGElement getSVGElement(SVGImage sVGImage) {
        SVGSVGElement sVGSVGElement = null;
        Document document = sVGImage.getDocument();
        sVGSVGElement = (SVGSVGElement)document.getElementById(this.getClass().getName() + this.id);
        if (sVGSVGElement == null) {
            sVGSVGElement = (SVGSVGElement)document.createElementNS(SVG_NAMESPACE, "svg");
            this.id = idCounter++;
            sVGSVGElement.setId(this.getClass().getName() + this.id);
        }
        return sVGSVGElement;
    }

    public Object rotate(Object object, int n) {
        if (object instanceof SVGImage) {
            SVGSVGElement sVGSVGElement = this.getSVGElement((SVGImage)object);
            SVGPoint sVGPoint = sVGSVGElement.getCurrentTranslate();
            sVGPoint.setX((float)(-this.getImageWidth(object) / 2));
            sVGPoint.setY((float)(-this.getImageHeight(object) / 2));
            sVGSVGElement.setCurrentRotate((float)n);
            sVGPoint.setX(0.0f);
            sVGPoint.setY(0.0f);
            return object;
        }
        return super.rotate(object, n);
    }

    public boolean isSVGSupported() {
        return true;
    }

    private InputStream openResURL(String string) throws IOException {
        int n = string.indexOf("!", 7);
        Resources resources = Resources.open(string.substring(6, n));
        return resources.getData(string.substring(n + 1));
    }

    public Object createSVGImage(String string, byte[] byArray) throws IOException {
        ScalableImage scalableImage = ScalableImage.createImage((InputStream)new ByteArrayInputStream(byArray), (ExternalResourceHandler)new Handler(string));
        return scalableImage;
    }

    class Handler
    implements ExternalResourceHandler {
        private String baseURL;

        public Handler(String string) {
            this.baseURL = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestResource(ScalableImage scalableImage, String string) {
            InputStream inputStream = null;
            try {
                if (string.indexOf(58) > -1) {
                    inputStream = string.startsWith("res:") ? SVGImplementation.this.openResURL(string) : Connector.openInputStream((String)string);
                    scalableImage.requestCompleted(string, inputStream);
                } else if (this.baseURL != null && this.baseURL.indexOf(58) > -1) {
                    String string2 = this.baseURL;
                    if (!this.baseURL.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    inputStream = string2.startsWith("res:") ? SVGImplementation.this.openResURL(string2 + string) : Connector.openInputStream((String)(string2 + string));
                    scalableImage.requestCompleted(string, inputStream);
                } else {
                    inputStream = Display.getInstance().getResourceAsStream(this.getClass(), string);
                    scalableImage.requestCompleted(string, inputStream);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

