/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.table;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;
import java.util.Vector;

public class TableLayout
extends Layout {
    private int currentRow;
    private int currentColumn;
    private static int minimumSizePerColumn = 10;
    private Constraint[][] tablePositions;
    private int[] columnSizes;
    private int[] columnPositions;
    private int[] rowPositions;
    private boolean[] modifableColumnSize;
    private static final Constraint H_SPAN_CONSTRAINT = new Constraint();
    private static final Constraint V_SPAN_CONSTRAINT = new Constraint();
    private static final Constraint VH_SPAN_CONSTRAINT = new Constraint();
    private static int defaultColumnWidth = -1;
    private static int defaultRowHeight = -1;
    private boolean horizontalSpanningExists;
    private boolean verticalSpanningExists;

    public TableLayout(int n, int n2) {
        this.tablePositions = new Constraint[n][n2];
    }

    public int getRows() {
        return this.tablePositions.length;
    }

    public int getColumns() {
        return this.tablePositions[0].length;
    }

    public Component getComponentAt(int n, int n2) {
        return this.tablePositions[n][n2].parent;
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        this.verticalSpanningExists = false;
        this.horizontalSpanningExists = false;
        Style style = container.getStyle();
        int n5 = style.getPadding(false, 0);
        int n6 = style.getPadding(container.isRTL(), 1);
        int n7 = style.getPadding(false, 2);
        int n8 = style.getPadding(container.isRTL(), 3);
        boolean bl = container.isRTL();
        this.columnSizes = new int[this.tablePositions[0].length];
        if (this.modifableColumnSize == null) {
            this.modifableColumnSize = new boolean[this.tablePositions[0].length];
        }
        this.columnPositions = new int[this.tablePositions[0].length];
        int[] nArray = new int[this.tablePositions.length];
        this.rowPositions = new int[this.tablePositions.length];
        int n9 = container.getLayoutWidth() - container.getSideGap() - n6 - n8;
        int n10 = container.getLayoutHeight() - container.getBottomGap() - n5 - n7;
        int n11 = n6;
        for (n4 = 0; n4 < this.columnSizes.length; ++n4) {
            this.columnSizes[n4] = this.getColumnWidthPixels(n4, n9, n9);
        }
        if (!container.isScrollableX()) {
            n4 = 0;
            n3 = 0;
            for (n2 = 0; n2 < this.modifableColumnSize.length; ++n2) {
                if (this.modifableColumnSize[n2]) {
                    n3 += this.columnSizes[n2];
                }
                n4 += this.columnSizes[n2];
            }
            if (n9 < n4) {
                n2 = n4 - n9;
                int n12 = n3 - n2;
                for (n = 0; n < this.modifableColumnSize.length; ++n) {
                    if (!this.modifableColumnSize[n]) continue;
                    this.columnSizes[n] = (int)((float)this.columnSizes[n] / (float)n3 * (float)n12);
                }
            }
        }
        for (n4 = 0; n4 < this.columnSizes.length; ++n4) {
            if (bl) {
                this.columnPositions[n4] = n9 - (n11 += this.columnSizes[n4]);
                continue;
            }
            this.columnPositions[n4] = n11;
            n11 += this.columnSizes[n4];
        }
        n4 = n5;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = container.isScrollableY() ? this.getRowHeightPixels(n3, n10, -1) : this.getRowHeightPixels(n3, n10, n10 - n4 + n5);
            this.rowPositions[n3] = n4;
            n4 += nArray[n3];
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            for (n2 = 0; n2 < this.columnSizes.length; ++n2) {
                int n13;
                int n14;
                int n15;
                int n16;
                Constraint constraint = this.tablePositions[n3][n2];
                if (constraint == null || constraint == H_SPAN_CONSTRAINT || constraint == V_SPAN_CONSTRAINT || constraint == VH_SPAN_CONSTRAINT) continue;
                Style style2 = constraint.parent.getStyle();
                int n17 = style2.getMargin(container.isRTL(), 1);
                int n18 = style2.getMargin(false, 0);
                n = n17 + this.columnPositions[n2];
                int n19 = n18 + this.rowPositions[n3];
                if (constraint.spanHorizontal > 1) {
                    this.horizontalSpanningExists = true;
                    n16 = this.columnSizes[n2];
                    for (n15 = 1; n15 < constraint.spanHorizontal; ++n15) {
                        n16 += this.columnSizes[Math.min(n2 + n15, this.columnSizes.length - 1)];
                    }
                    if (bl) {
                        n = n6 + n17 + this.columnPositions[n2 + constraint.spanHorizontal - 1];
                    }
                    n14 = n16 - n17 - style2.getMargin(container.isRTL(), 3);
                } else {
                    n14 = this.columnSizes[n2] - n17 - style2.getMargin(container.isRTL(), 3);
                }
                if (constraint.spanVertical > 1) {
                    this.verticalSpanningExists = true;
                    n16 = nArray[n3];
                    for (n15 = 1; n15 < constraint.spanVertical; ++n15) {
                        n16 += nArray[Math.min(n3 + n15, nArray.length - 1)];
                    }
                    n13 = n16 - n18 - style2.getMargin(false, 2);
                } else {
                    n13 = nArray[n3] - n18 - style2.getMargin(false, 2);
                }
                this.placeComponent(bl, constraint, n, n19, n14, n13);
            }
        }
    }

    public int getRowPosition(int n) {
        if (this.rowPositions != null && this.rowPositions.length > n) {
            return this.rowPositions[n];
        }
        return -1;
    }

    public int getColumnPosition(int n) {
        if (this.columnPositions != null && this.columnPositions.length > n) {
            return this.columnPositions[n];
        }
        return -1;
    }

    private void placeComponent(boolean bl, Constraint constraint, int n, int n2, int n3, int n4) {
        int n5;
        constraint.parent.setX(n);
        constraint.parent.setY(n2);
        constraint.parent.setWidth(n3);
        constraint.parent.setHeight(n4);
        Dimension dimension = constraint.parent.getPreferredSize();
        int n6 = dimension.getWidth();
        int n7 = dimension.getHeight();
        if (n6 < n3) {
            n5 = n3 - n6;
            int n8 = constraint.align;
            if (bl) {
                switch (n8) {
                    case 1: {
                        n8 = 3;
                        break;
                    }
                    case 3: {
                        n8 = 1;
                    }
                }
            }
            switch (n8) {
                case 1: {
                    constraint.parent.setX(n);
                    constraint.parent.setWidth(n3 - n5);
                    break;
                }
                case 3: {
                    constraint.parent.setX(n + n5);
                    constraint.parent.setWidth(n3 - n5);
                    break;
                }
                case 4: {
                    constraint.parent.setX(n + n5 / 2);
                    constraint.parent.setWidth(n3 - n5);
                }
            }
        }
        if (n7 < n4) {
            n5 = n4 - n7;
            switch (constraint.valign) {
                case 0: {
                    constraint.parent.setY(n2);
                    constraint.parent.setHeight(n4 - n5);
                    break;
                }
                case 2: {
                    constraint.parent.setY(n2 + n5);
                    constraint.parent.setHeight(n4 - n5);
                    break;
                }
                case 4: {
                    constraint.parent.setY(n2 + n5 / 2);
                    constraint.parent.setHeight(n4 - n5);
                }
            }
        }
    }

    private int getColumnWidthPixels(int n, int n2, int n3) {
        int n4 = 0;
        if (this.modifableColumnSize == null) {
            this.modifableColumnSize = new boolean[this.tablePositions[0].length];
        }
        for (int i = 0; i < this.tablePositions.length; ++i) {
            Constraint constraint = this.tablePositions[i][n];
            if (constraint == null || constraint == H_SPAN_CONSTRAINT || constraint == V_SPAN_CONSTRAINT || constraint == VH_SPAN_CONSTRAINT) continue;
            if (constraint.width > 0 && n3 > -1) {
                n4 = Math.max(n4, constraint.width * n2 / 100);
                this.modifableColumnSize[n] = false;
            } else {
                Style style = constraint.parent.getStyle();
                n4 = Math.max(n4, constraint.parent.getPreferredW() + style.getMargin(false, 1) + style.getMargin(false, 3));
                this.modifableColumnSize[n] = true;
            }
            if (n3 <= -1) continue;
            n4 = Math.min(n3, n4);
        }
        return n4;
    }

    private int getRowHeightPixels(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < this.tablePositions[n].length; ++i) {
            Constraint constraint = this.tablePositions[n][i];
            if (constraint == null || constraint == H_SPAN_CONSTRAINT || constraint == V_SPAN_CONSTRAINT || constraint == VH_SPAN_CONSTRAINT) continue;
            if (constraint.height > 0) {
                n4 = Math.max(n4, constraint.height * n2 / 100);
            } else {
                Style style = constraint.parent.getStyle();
                n4 = Math.max(n4, constraint.parent.getPreferredH() + style.getMargin(false, 0) + style.getMargin(false, 2));
            }
            if (n3 <= -1) continue;
            n4 = Math.min(n3, n4);
        }
        return n4;
    }

    public Dimension getPreferredSize(Container container) {
        int n;
        Style style = container.getStyle();
        int n2 = style.getPadding(false, 1) + style.getPadding(false, 3);
        int n3 = style.getPadding(false, 0) + style.getPadding(false, 2);
        for (n = 0; n < this.tablePositions[0].length; ++n) {
            n2 += this.getColumnWidthPixels(n, Integer.MAX_VALUE, -1);
        }
        for (n = 0; n < this.tablePositions.length; ++n) {
            n3 += this.getRowHeightPixels(n, Integer.MAX_VALUE, -1);
        }
        return new Dimension(n2, n3);
    }

    public int getNextRow() {
        return this.currentRow;
    }

    public int getNextColumn() {
        return this.currentColumn;
    }

    private void shiftCell(int n, int n2) {
        int n3;
        Constraint constraint = this.tablePositions[n][n2];
        for (n3 = n2 + 1; n3 < this.tablePositions[n].length; ++n3) {
            if (this.tablePositions[n][n3] == null) {
                this.tablePositions[n][n3] = constraint;
                return;
            }
            Constraint constraint2 = this.tablePositions[n][n3];
            this.tablePositions[n][n3] = constraint;
            constraint = constraint2;
        }
        for (n3 = n + 1; n3 < this.getRows(); ++n3) {
            for (int i = 0; i < this.getColumns(); ++i) {
                if (this.tablePositions[n3][i] == null) {
                    this.tablePositions[n3][i] = constraint;
                    return;
                }
                Constraint constraint3 = this.tablePositions[n3][i];
                this.tablePositions[n3][i] = constraint;
                constraint = constraint3;
            }
        }
        this.addRow();
    }

    private void addRow() {
        Constraint[][] constraintArray = new Constraint[this.tablePositions.length + 1][this.tablePositions[0].length];
        for (int i = 0; i < this.tablePositions.length; ++i) {
            constraintArray[i] = this.tablePositions[i];
        }
        this.tablePositions = constraintArray;
    }

    public void addLayoutComponent(Object object, Component component, Container container) {
        Constraint constraint = (Constraint)object;
        if (constraint == null) {
            constraint = this.createConstraint();
        } else if (constraint.parent != null) {
            throw new IllegalArgumentException("Constraint already associated with component!");
        }
        constraint.actualRow = constraint.row;
        constraint.actualColumn = constraint.column;
        if (constraint.actualRow < 0) {
            constraint.actualRow = this.currentRow;
        }
        if (constraint.actualColumn < 0) {
            constraint.actualColumn = this.currentColumn;
        }
        constraint.parent = component;
        if (constraint.actualRow >= this.tablePositions.length) {
            this.addRow();
        }
        if (this.tablePositions[constraint.actualRow][constraint.actualColumn] != null) {
            if (this.tablePositions[constraint.actualRow][constraint.actualColumn].row != -1 || this.tablePositions[constraint.actualRow][constraint.actualColumn].column != -1) {
                throw new IllegalArgumentException("Row: " + constraint.row + " and column: " + constraint.column + " already occupied");
            }
            this.shiftCell(constraint.actualRow, constraint.actualColumn);
            this.tablePositions[constraint.actualRow][constraint.actualColumn] = constraint;
        }
        this.tablePositions[constraint.actualRow][constraint.actualColumn] = constraint;
        if (constraint.spanHorizontal > 1 || constraint.spanVertical > 1) {
            for (int i = 0; i < constraint.spanHorizontal; ++i) {
                for (int j = 0; j < constraint.spanVertical; ++j) {
                    if (i <= 0 && j <= 0 || this.tablePositions.length <= constraint.actualRow + j || this.tablePositions[constraint.actualRow + j].length <= constraint.actualColumn + i || this.tablePositions[constraint.actualRow + j][constraint.actualColumn + i] != null) continue;
                    if (constraint.spanHorizontal > 1) {
                        if (constraint.spanVertical > 1) {
                            this.tablePositions[constraint.actualRow + j][constraint.actualColumn + i] = VH_SPAN_CONSTRAINT;
                            continue;
                        }
                        this.tablePositions[constraint.actualRow + j][constraint.actualColumn + i] = V_SPAN_CONSTRAINT;
                        continue;
                    }
                    this.tablePositions[constraint.actualRow + j][constraint.actualColumn + i] = H_SPAN_CONSTRAINT;
                }
            }
        }
        this.updateRowColumn();
    }

    private void updateRowColumn() {
        if (this.currentRow >= this.tablePositions.length) {
            return;
        }
        while (this.tablePositions[this.currentRow][this.currentColumn] != null) {
            ++this.currentColumn;
            if (this.currentColumn < this.tablePositions[0].length) continue;
            this.currentColumn = 0;
            ++this.currentRow;
            if (this.currentRow < this.tablePositions.length) continue;
            return;
        }
    }

    public int getCellHorizontalSpan(int n, int n2) {
        return this.tablePositions[n][n2].spanHorizontal;
    }

    public int getCellVerticalSpan(int n, int n2) {
        return this.tablePositions[n][n2].spanVertical;
    }

    public boolean isCellSpannedThroughVertically(int n, int n2) {
        return this.tablePositions[n][n2] == V_SPAN_CONSTRAINT || this.tablePositions[n][n2] == VH_SPAN_CONSTRAINT;
    }

    public boolean isCellSpannedThroughHorizontally(int n, int n2) {
        return this.tablePositions[n][n2] == H_SPAN_CONSTRAINT || this.tablePositions[n][n2] == VH_SPAN_CONSTRAINT;
    }

    public boolean hasVerticalSpanning() {
        return this.verticalSpanningExists;
    }

    public boolean hasHorizontalSpanning() {
        return this.horizontalSpanningExists;
    }

    public void removeLayoutComponent(Component component) {
        int n;
        int n2;
        Vector<Constraint> vector = new Vector<Constraint>();
        for (n2 = 0; n2 < this.tablePositions.length; ++n2) {
            for (n = 0; n < this.tablePositions[n2].length; ++n) {
                if (this.tablePositions[n2][n] != null) {
                    if (this.tablePositions[n2][n].parent != component) {
                        vector.addElement(this.tablePositions[n2][n]);
                    } else {
                        this.tablePositions[n2][n].parent = null;
                    }
                }
                this.tablePositions[n2][n] = null;
            }
        }
        this.currentRow = 0;
        this.currentColumn = 0;
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            Constraint constraint = (Constraint)vector.elementAt(n);
            if (constraint == H_SPAN_CONSTRAINT || constraint == V_SPAN_CONSTRAINT || constraint == VH_SPAN_CONSTRAINT) continue;
            Component component2 = constraint.parent;
            constraint.parent = null;
            this.addLayoutComponent(constraint, component2, component2.getParent());
        }
    }

    public Object getComponentConstraint(Component component) {
        for (int i = 0; i < this.tablePositions.length; ++i) {
            for (int j = 0; j < this.tablePositions[i].length; ++j) {
                if (this.tablePositions[i][j] == null || this.tablePositions[i][j].parent != component) continue;
                return this.tablePositions[i][j];
            }
        }
        return null;
    }

    public Constraint createConstraint() {
        return new Constraint();
    }

    public Constraint createConstraint(int n, int n2) {
        Constraint constraint = this.createConstraint();
        constraint.row = n;
        constraint.column = n2;
        return constraint;
    }

    public static void setMinimumSizePerColumn(int n) {
        minimumSizePerColumn = n;
    }

    public static int getMinimumSizePerColumn() {
        return minimumSizePerColumn;
    }

    public static void setDefaultColumnWidth(int n) {
        defaultColumnWidth = n;
    }

    public static int getDefaultColumnWidth() {
        return defaultColumnWidth;
    }

    public static void setDefaultRowHeight(int n) {
        defaultRowHeight = n;
    }

    public static int getDefaultRowHeight() {
        return defaultRowHeight;
    }

    public String toString() {
        return "TableLayout";
    }

    public boolean equals(Object object) {
        return super.equals(object) && ((TableLayout)object).getRows() == this.getRows() && ((TableLayout)object).getColumns() == this.getColumns();
    }

    static /* synthetic */ int access$900() {
        return defaultColumnWidth;
    }

    static /* synthetic */ int access$1000() {
        return defaultRowHeight;
    }

    public static class Constraint {
        private Component parent;
        private int row = -1;
        private int column = -1;
        private int width = TableLayout.access$900();
        private int height = TableLayout.access$1000();
        private int spanHorizontal = 1;
        private int spanVertical = 1;
        private int align = -1;
        private int valign = -1;
        int actualRow = -1;
        int actualColumn = -1;

        public void setVerticalSpan(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanVertical = n;
        }

        public void setHorizontalSpan(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanHorizontal = n;
        }

        public void setWidthPercentage(int n) {
            this.width = n;
        }

        public void setHeightPercentage(int n) {
            this.height = n;
        }

        public void setHorizontalAlign(int n) {
            this.align = n;
        }

        public void setVerticalAlign(int n) {
            this.valign = n;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public int getWidthPercentage() {
            return this.width;
        }

        public int getHeightPercentage() {
            return this.height;
        }

        public int getHorizontalSpan() {
            return this.spanHorizontal;
        }

        public int getVerticalSpan() {
            return this.spanVertical;
        }

        public int getHorizontalAlign() {
            return this.align;
        }

        public int getVerticalAlign() {
            return this.valign;
        }
    }
}

