/*
 * Decompiled with CFR 0.152.
 */
package com.substanceofcode.twitter;

import com.substanceofcode.infrastructure.Device;
import com.substanceofcode.tasks.AbstractTask;
import com.substanceofcode.twitter.PhotoService;
import com.substanceofcode.twitter.Settings;
import com.substanceofcode.twitter.TwitterApi;
import com.substanceofcode.twitter.TwitterMidlet;
import com.substanceofcode.twitter.VideoService;
import com.substanceofcode.twitter.model.MediaFileSelect;
import com.substanceofcode.twitter.model.Status;
import com.substanceofcode.twitter.model.UserList;
import com.substanceofcode.twitter.services.RefreshService;
import com.substanceofcode.twitter.tasks.RequestFriendsTask;
import com.substanceofcode.twitter.tasks.RequestListsTask;
import com.substanceofcode.twitter.tasks.RequestTimelineTask;
import com.substanceofcode.twitter.tasks.SearchTask;
import com.substanceofcode.twitter.tasks.SendPhotoTask;
import com.substanceofcode.twitter.tasks.SendVideoTask;
import com.substanceofcode.twitter.tasks.ToggleFavoriteTask;
import com.substanceofcode.twitter.tasks.ToggleFollowingTask;
import com.substanceofcode.twitter.tasks.TranslateTask;
import com.substanceofcode.twitter.tasks.UpdateStatusTask;
import com.substanceofcode.twitter.views.AboutCanvas;
import com.substanceofcode.twitter.views.CameraCanvas;
import com.substanceofcode.twitter.views.FileBrowserCanvas;
import com.substanceofcode.twitter.views.MediaCommentForm;
import com.substanceofcode.twitter.views.MenuAction;
import com.substanceofcode.twitter.views.SearchTextBox;
import com.substanceofcode.twitter.views.SettingsForm;
import com.substanceofcode.twitter.views.SplashCanvas;
import com.substanceofcode.twitter.views.Theme;
import com.substanceofcode.twitter.views.TimelineCanvas;
import com.substanceofcode.twitter.views.UpdateStatusTextBox;
import com.substanceofcode.twitter.views.WaitCanvas;
import com.substanceofcode.twitter.views.menus.ListsMenu;
import com.substanceofcode.twitter.views.menus.OpenListMenuAction;
import com.substanceofcode.twitter.views.menus.PhotoServicesMenu;
import com.substanceofcode.twitter.views.menus.VideoServicesMenu;
import com.substanceofcode.utils.Log;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TwitterController {
    private TwitterMidlet a;
    private Display a;
    private TwitterApi a;
    private Settings a;
    private TimelineCanvas a;
    private PhotoService a;
    private VideoService a;
    private FileBrowserCanvas a;
    private boolean a;
    private Vector a;
    private Vector b;
    private Vector c;
    private Vector d;
    private Vector e;
    private Vector f;
    private Vector g;
    private Vector h;
    private int a = false;
    private static TwitterController a;

    public static TwitterController getInstance(TwitterMidlet twitterMidlet) {
        if (a == null) {
            a = new TwitterController(twitterMidlet);
        }
        return a;
    }

    public static TwitterController getInstance() {
        return a;
    }

    private TwitterController(TwitterMidlet object) {
        try {
            this.a = object;
            this.a = Display.getDisplay((MIDlet)object);
            this.a = new TwitterApi();
            this.a = new TimelineCanvas(this);
            this.a = Settings.getInstance(object);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (RecordStoreException recordStoreException) {
            object = recordStoreException;
            recordStoreException.printStackTrace();
            return;
        }
    }

    public void about() {
        AboutCanvas aboutCanvas = new AboutCanvas(this);
        this.a.setCurrent((Displayable)aboutCanvas);
    }

    public void addFavoriteStatus(Status status) {
        if (this.g != null) {
            this.g.addElement(status);
        }
    }

    public void addStatus(Status status) {
        if (this.b != null) {
            this.b.insertElementAt(status, 0);
        }
        if (this.c != null) {
            this.c.insertElementAt(status, 0);
        }
    }

    public void clearTimelines() {
        this.setHomeTimeline(null);
        this.setPublicTimeline(null);
        this.setResponsesTimeline(null);
        this.setUserTimeline(null);
        this.setDirectTimeline(null);
        this.setFriendsStatuses(null);
        this.setFavouriteTimeline(null);
    }

    public MIDlet getMIDlet() {
        return this.a;
    }

    public Settings getSettings() {
        return this.a;
    }

    public void exit() {
        try {
            TwitterMidlet twitterMidlet = this.a;
            twitterMidlet.notifyDestroyed();
            return;
        }
        catch (Exception exception) {
            Log.error("\u0412\u044b\u0445\u043e\u0434: " + exception.toString());
            return;
        }
    }

    public Displayable getCurrentDisplay() {
        return this.a.getCurrent();
    }

    public void login() {
        String string = this.a.getStringProperty("username", "");
        this.a.setUsername(string);
        String string2 = this.a.getStringProperty("password", "");
        this.a.setPassword(string2);
        String string3 = this.a.getStringProperty("token", "");
        String string4 = this.a.getStringProperty("tokensecret", "");
        this.a.bypassAuthorization(string3, string4);
        boolean bl = this.a.getBooleanProperty("loadonstartup", false);
        this.login(string, string2, bl);
    }

    public void login(String string, String vector, boolean bl) {
        this.a.setUsername(string);
        this.a.setPassword((String)((Object)vector));
        int n = this.a.getIntProperty("theme", 0);
        Theme.setTheme(n);
        n = this.a.getBooleanProperty("refresh", false) ? 1 : 0;
        vector = RefreshService.getInstance();
        if (n != 0) {
            ((RefreshService)((Object)vector)).activate();
        } else {
            ((RefreshService)((Object)vector)).deactivate();
        }
        if (bl) {
            this.a.authorize();
            this.showHomeTimeline(false);
            return;
        }
        TwitterController twitterController = this;
        vector = new Vector<Status>();
        twitterController.a.showDrawNextPageLink(false);
        vector.addElement(new Status("Twim", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0447\u044c\u0438 \u0431\u044b \u0432\u044b \u0445\u043e\u0442\u0435\u043b\u0438 \u0432\u0438\u0434\u0435\u0442\u044c \u0442\u0432\u0438\u0442\u044b", Calendar.getInstance().getTime(), "0"));
        if (Device.isTouch()) {
            twitterController.a.resetMenuTab();
        }
        twitterController.a.setTimeline(vector);
        twitterController.a.setCurrent((Displayable)twitterController.a);
    }

    public void commentMedia(byte[] object, String string) {
        object = (Object)new MediaCommentForm((byte[])object, string);
        this.a.setCurrent((Displayable)object);
    }

    public void minimize() {
        this.a.setCurrent((Displayable)this.a);
        this.a.setCurrent(null);
    }

    public void setPhotoService(PhotoService photoService) {
        this.a = photoService;
        this.a = null;
    }

    public void setVideoService(VideoService videoService) {
        this.a = videoService;
        this.a = null;
    }

    public void showMediaService(byte[] object, boolean bl, String string) {
        if (bl) {
            object = (Object)new PhotoServicesMenu((byte[])object, string);
            this.a.setCurrent((Displayable)object);
            return;
        }
        object = (Object)new VideoServicesMenu((byte[])object, string);
        this.a.setCurrent((Displayable)object);
    }

    public void showVideoBrowser() {
        if (this.a == null) {
            this.a = new FileBrowserCanvas(new MediaFileSelect(false));
            this.a.showRoots();
        }
        this.a.resetToLastFolder();
        this.a.setCurrent((Displayable)this.a);
    }

    public void toggleFavorite(Status status) {
        Runnable runnable = new ToggleFavoriteTask(this, this.a, status);
        runnable = new WaitCanvas(this, (AbstractTask)runnable);
        if (status.isFavorite()) {
            ((WaitCanvas)runnable).setWaitText("\u041d\u0435\u043b\u044e\u0431\u0438\u043c\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441...");
        } else {
            ((WaitCanvas)runnable).setWaitText("\u041c\u0430\u0440\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u043a\u0430\u043a \u043b\u044e\u0431\u0438\u043c\u044b\u0439...");
        }
        this.a.setCurrent((Displayable)runnable);
    }

    public void sendMedia(String object, String string, byte[] byArray) {
        String string2 = this.a.getUsername();
        String string3 = this.a.getPassword();
        object = this.a != null ? new SendPhotoTask(byArray, (String)object, string2, string3, this.a, string) : new SendVideoTask(byArray, (String)object, string2, string3, this.a, string);
        object = new WaitCanvas(this, (AbstractTask)object);
        ((WaitCanvas)object).setWaitText("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430...");
        this.a.setCurrent((Displayable)object);
    }

    public void setPublicTimeline(Vector vector) {
        this.a = vector;
    }

    public void setResponsesTimeline(Vector vector) {
        this.d = vector;
    }

    public void setUserTimeline(Vector vector) {
        this.c = vector;
    }

    public void setDirectTimeline(Vector vector) {
        this.e = vector;
    }

    public void setFriendsStatuses(Vector vector) {
        this.f = vector;
    }

    public void showCamera() {
        CameraCanvas cameraCanvas = new CameraCanvas();
        this.a.setCurrent((Displayable)cameraCanvas);
        cameraCanvas.start();
    }

    public void showDirectMessages() {
        this.a = 4;
        this.a.showDrawNextPageLink(false);
        if (this.e == null) {
            Runnable runnable = new RequestTimelineTask(this, this.a, 4, 1);
            runnable = new WaitCanvas(this, (AbstractTask)runnable);
            this.a.setCurrent((Displayable)runnable);
            return;
        }
        this.a.setTimeline(this.e);
        this.a.setCurrent((Displayable)this.a);
    }

    public void showError(String string) {
        Alert alert = new Alert("\u041e\u0448\u0438\u0431\u043a\u0430");
        alert.setString(string);
        alert.setTimeout(-2);
        this.a.setCurrent(alert, (Displayable)this.a);
    }

    public void showInfo(String string) {
        Alert alert = new Alert("\u0418\u043d\u0444\u043e");
        alert.setString(string);
        alert.setTimeout(-2);
        this.a.setCurrent(alert, (Displayable)this.a);
    }

    public void showPhotoBrowser() {
        try {
            if (this.a == null) {
                this.a = new FileBrowserCanvas(new MediaFileSelect(true));
                this.a.showRoots();
            }
            this.a.resetToLastFolder();
            this.a.setCurrent((Displayable)this.a);
            return;
        }
        catch (Exception exception) {
            this.showError("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0444\u043e\u0442\u043e \u0432 \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0435 \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438.  \u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442, File Connection API calls. Err: " + exception.getMessage());
            return;
        }
    }

    public void showFriends() {
        this.a = 5;
        this.a.showDrawNextPageLink(false);
        if (this.f == null) {
            Runnable runnable = new RequestFriendsTask(this, this.a);
            runnable = new WaitCanvas(this, (AbstractTask)runnable);
            ((WaitCanvas)runnable).setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0440\u0443\u0437\u0435\u0439");
            this.a.setCurrent((Displayable)runnable);
            return;
        }
        this.a.setTimeline(this.f);
        this.a.setCurrent((Displayable)this.a);
    }

    public void showFriends(Vector vector) {
        this.a = 5;
        this.a.showDrawNextPageLink(false);
        this.a.setTimeline(vector);
        this.a.setCurrent((Displayable)this.a);
    }

    public void showPublicTimeline() {
        this.a = 0;
        this.a.showDrawNextPageLink(false);
        if (this.a == null) {
            Runnable runnable = new RequestTimelineTask(this, this.a, 3, 1);
            runnable = new WaitCanvas(this, (AbstractTask)runnable);
            this.a.setCurrent((Displayable)runnable);
            return;
        }
        this.a.setTimeline(this.a);
        this.a.setCurrent((Displayable)this.a);
    }

    public void showResponsesTimeline() {
        this.a = 3;
        this.a.showDrawNextPageLink(false);
        if (this.d == null) {
            Runnable runnable = new RequestTimelineTask(this, this.a, 1, 1);
            runnable = new WaitCanvas(this, (AbstractTask)runnable);
            ((WaitCanvas)runnable).setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u043e\u0432...");
            this.a.setCurrent((Displayable)runnable);
            return;
        }
        this.a.setTimeline(this.d);
        this.a.setCurrent((Displayable)this.a);
    }

    public void showRetweetsOfMeTimeline(boolean bl) {
        this.a = 8;
        this.a.showDrawNextPageLink(true);
        if (this.h == null || bl) {
            this.a.selectRetweetsOfMeTab(!bl);
            int n = 1;
            if (bl && this.h != null) {
                int runnable = this.h.size() / 20;
                n = runnable + 1;
            }
            RequestTimelineTask requestTimelineTask = new RequestTimelineTask(this, this.a, 6, n);
            WaitCanvas waitCanvas = new WaitCanvas(this, requestTimelineTask);
            waitCanvas.setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0440\u0435\u0442\u0432\u0438\u0442\u043e\u0432 \u043e \u0432\u0430\u0441...");
            if (this.a.getCurrent() != null || !this.a) {
                this.a.setCurrent((Displayable)waitCanvas);
            }
            return;
        }
        this.a.setTimeline(this.b);
        this.a.resetScrolling();
        if (this.a.getCurrent() != null || !this.a) {
            this.a.setCurrent((Displayable)this.a);
        }
        this.a = true;
    }

    public void showStatusView(String object) {
        object = new UpdateStatusTextBox(this, (String)object);
        this.a.setCurrent((Displayable)object);
    }

    public void toggleFollow(Status status) {
        Runnable runnable = new ToggleFollowingTask(this, this.a, status);
        runnable = new WaitCanvas(this, (AbstractTask)runnable);
        String string = status.isFollowing() ? "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443" : "\u0421\u043b\u0435\u0434\u0438\u0442\u044c";
        ((WaitCanvas)runnable).setWaitText(string + " " + status.getScreenName() + "...");
        this.a.setCurrent((Displayable)runnable);
    }

    public void updateStatus(String object) {
        object = new UpdateStatusTask(this, this.a, (String)object);
        object = new WaitCanvas(this, (AbstractTask)object);
        ((WaitCanvas)object).setWaitText("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430...");
        this.a.setCurrent((Displayable)object);
    }

    public void useArchiveTimeline() {
        this.a.setTimeline(this.c);
    }

    public void useResponsesTimeline() {
        this.a.setTimeline(this.d);
    }

    public void showArchiveTimeline(boolean bl) {
        this.a = 2;
        this.a.showDrawNextPageLink(false);
        if (this.c == null) {
            Runnable runnable = new RequestTimelineTask(this, this.a, 2, 1);
            runnable = new WaitCanvas(this, (AbstractTask)runnable);
            ((WaitCanvas)runnable).setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0432\u0438\u0442\u043e\u0432...");
            this.a.setCurrent((Displayable)runnable);
            return;
        }
        this.a.setTimeline(this.c);
        this.a.setCurrent((Displayable)this.a);
    }

    public void setHomeTimeline(Vector vector) {
        this.b = vector;
    }

    public void setFavouriteTimeline(Vector vector) {
        this.g = vector;
    }

    public void showSettingsForm() {
        SettingsForm settingsForm = new SettingsForm(this);
        this.a.setCurrent((Displayable)settingsForm);
    }

    public boolean isMinimized() {
        return this.a.getCurrent() == null;
    }

    public void showHomeTimeline(boolean bl) {
        this.a = 1;
        this.a.showDrawNextPageLink(true);
        if (this.b == null || bl) {
            this.a.selectHomeTab(!bl);
            int n = 1;
            if (bl && this.b != null) {
                int runnable = this.b.size() / 20;
                n = runnable + 1;
            }
            RequestTimelineTask requestTimelineTask = new RequestTimelineTask(this, this.a, 0, n);
            WaitCanvas waitCanvas = new WaitCanvas(this, requestTimelineTask);
            waitCanvas.setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...");
            if (this.a.getCurrent() != null || !this.a) {
                this.a.setCurrent((Displayable)waitCanvas);
            }
            return;
        }
        this.a.setTimeline(this.b);
        this.a.resetScrolling();
        if (this.a.getCurrent() != null || !this.a) {
            this.a.setCurrent((Displayable)this.a);
        }
        this.a = true;
    }

    public void showFavouriteTimeline() {
        this.a = 6;
        this.a.showDrawNextPageLink(false);
        if (this.g == null) {
            Runnable runnable = new RequestTimelineTask(this, this.a, 5, 1);
            runnable = new WaitCanvas(this, (AbstractTask)runnable);
            ((WaitCanvas)runnable).setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430...");
            this.a.setCurrent((Displayable)runnable);
            return;
        }
        this.a.setTimeline(this.g);
        this.a.resetScrolling();
        this.a.setCurrent((Displayable)this.a);
    }

    public void showTimeline(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            this.showError("\u041d\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f");
            return;
        }
        this.a.setTimeline(vector);
        if (this.a.getCurrent() != null) {
            this.a.setCurrent((Displayable)this.a);
        }
    }

    public void showTimeline() {
        this.a.resetScrolling();
        this.a.resetMenus();
        this.a.setCurrent((Displayable)this.a);
    }

    public void showSplash() {
        SplashCanvas splashCanvas = new SplashCanvas(this);
        this.a.setCurrent((Displayable)splashCanvas);
    }

    public void removeFavoriteStatus(Status status) {
        Enumeration enumeration = this.g.elements();
        while (enumeration.hasMoreElements()) {
            Status status2 = (Status)enumeration.nextElement();
            if (!status2.getId().equals(status.getId())) continue;
            this.g.removeElement(status2);
        }
    }

    public void showSearchForm() {
        SearchTextBox searchTextBox = new SearchTextBox();
        this.a.setCurrent((Displayable)searchTextBox);
    }

    public void search(String object) {
        this.a.showDrawNextPageLink(true);
        this.a = 7;
        object = new SearchTask((String)object, this.a);
        object = new WaitCanvas(this, (AbstractTask)object);
        ((WaitCanvas)object).setWaitText("\u041f\u043e\u0438\u0441\u043a...");
        this.a.setCurrent((Displayable)object);
    }

    public void searchNextPage() {
        Runnable runnable = new SearchTask(this.a);
        SearchTask.turnPage();
        runnable = new WaitCanvas(this, (AbstractTask)runnable);
        ((WaitCanvas)runnable).setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u043b\u0435\u0434. \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b...");
        this.a.setCurrent((Displayable)runnable);
    }

    public void showTweets(Vector vector, String string) {
        this.a.setTimeline(vector);
        this.a.resetScrolling();
        this.a.resetMenuTab();
        this.a.setCurrent((Displayable)this.a);
    }

    public void showPreviousTimeline() {
        this.a.resetMenus();
        this.a.setCurrent((Displayable)this.a);
    }

    public Vector getRecentStatuses() {
        return this.b;
    }

    public void vibrate(int n) {
        this.a.vibrate(n);
    }

    public boolean canAutorefresh() {
        boolean bl = this.a.getCurrent() == this.a;
        return bl || this.isMinimized();
    }

    public void playInfoSound() {
        this.a.vibrate(500);
        AlertType.INFO.playSound(this.a);
    }

    public void translateToEnglish(Status object) {
        object = new TranslateTask((Status)object);
        object = new WaitCanvas(this, (AbstractTask)object);
        ((WaitCanvas)object).setWaitText("\u041f\u0435\u0440\u0435\u0432\u043e\u0434...");
        this.a.setCurrent((Displayable)object);
    }

    public void showSingleStatus(Status status) {
        Vector<Status> vector = new Vector<Status>(1);
        vector.addElement(status);
        this.a.setTimeline(vector);
        this.a.resetScrolling();
        this.a.setCurrent((Displayable)this.a);
    }

    public void loadNextPage() {
        switch (this.a) {
            case 0: {
                return;
            }
            case 1: {
                this.showHomeTimeline(true);
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
            case 6: {
                return;
            }
            case 7: {
                this.searchNextPage();
            }
        }
    }

    public void addToHomeTimeline(Vector vector) {
        Object object = vector;
        vector = this.b;
        if (object != null) {
            object = ((Vector)object).elements();
            while (object.hasMoreElements()) {
                Status status = (Status)object.nextElement();
                vector.addElement(status);
            }
        }
    }

    public Vector getHomeTimeline() {
        return this.b;
    }

    public void setRetweetsOfMeTimeline(Vector vector) {
        this.h = vector;
    }

    public Vector getRetweetsOfMeTimeline() {
        return this.h;
    }

    public void showLists(Vector object) {
        Object object2;
        MenuAction[] menuActionArray = new MenuAction[((Vector)object).size()];
        String[] stringArray = new String[((Vector)object).size()];
        object = ((Vector)object).elements();
        int n = 0;
        while (object.hasMoreElements()) {
            object2 = (UserList)object.nextElement();
            menuActionArray[n] = new OpenListMenuAction((UserList)object2);
            stringArray[n] = ((UserList)object2).getName();
            ++n;
        }
        object2 = new ListsMenu(stringArray, menuActionArray);
        this.a.setCurrent((Displayable)object2);
    }

    public void showLists() {
        Runnable runnable = new RequestListsTask(this, this.a);
        runnable = new WaitCanvas(this, (AbstractTask)runnable);
        ((WaitCanvas)runnable).setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u0430\u0448\u0438\u0445 \u0441\u043f\u0438\u0441\u043a\u043e\u0432...");
        this.a.setCurrent((Displayable)runnable);
    }

    public void showList(UserList userList) {
        Runnable runnable = new RequestTimelineTask(this, this.a, userList.getId());
        runnable = new WaitCanvas(this, (AbstractTask)runnable);
        ((WaitCanvas)runnable).setWaitText("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u043f\u0438\u0441\u043a\u0430 " + userList.getName());
        this.a.setCurrent((Displayable)runnable);
    }

    public void resetAuthenticationToken() {
        TwitterApi.a();
        this.showInfo("\u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0431\u044b\u043b\u0430 \u0441\u0431\u0440\u043e\u0448\u0435\u043d\u0430.");
    }
}

