package com.classpath.util;

public final class ByteCache
{
	// This caches Byte values, and is used by boxing conversions via
	// valueOf().  We're required to cache all possible values here.
	private static Byte[] byteCache = new Byte[Byte.MAX_VALUE - Byte.MIN_VALUE + 1];

	static
	{
		for(int i = Byte.MIN_VALUE; i <= Byte.MAX_VALUE; i++)
		{
			byteCache[i - Byte.MIN_VALUE] = new Byte((byte) i);
		}
	}

	/**
	 * Returns a <code>Byte</code> object wrapping the value.
	 * In contrast to the <code>Byte</code> constructor, this method
	 * will cache some values.  It is used by boxing conversion.
	 *
	 * @param val the value to wrap
	 * @return the <code>Byte</code>
	 */
	public static Byte valueOf(byte val)
	{
		return byteCache[val - Byte.MIN_VALUE];
	}
}
