package com.innosystec.unrar;

import com.classpath.io.PipedOutputStream;
import com.innosystec.unrar.rarfile.FileHeader;
import java.io.IOException;

public class ExtractThread implements Runnable
{
	protected Archive archive;
	protected FileHeader fh;
	protected PipedOutputStream os;

	public ExtractThread(Archive archive, FileHeader fh, PipedOutputStream os)
	{
		this.archive = archive;
		this.fh = fh;
		this.os = os;
	}

	public void run()
	{
		System.gc();
		
		try
		{
			archive.extractFile(fh, os);
		}
		catch(IOException ioe)
		{
			os.passException(ioe);
		}
		catch(Throwable t)
		{
			os.passException(new IOException(t.toString()));
		}

		try
		{
			os.close();
		}
		catch(IOException e)
		{
			e.printStackTrace();
		}
	}
}
