package com.innosystec.unrar;

import com.innosystec.unrar.rarfile.FileHeader;
import com.one.ArchiveEntry;

public class RarEntry extends ArchiveEntry
{
	protected FileHeader fh;

	public RarEntry(FileHeader fh)
	{
		this.fh = fh;

		name = fh.getFileNameString();

		if(name != null)
		{
			name = name.replace('\\', '/');

			if(fh.isDirectory() && !name.endsWith("/"))
			{
				name += "/";
			}
		}
		
		size = fh.getFullUnpackSize();
		compressedSize = fh.getFullPackSize();
	}

	public FileHeader getFileHeader()
	{
		return fh;
	}
}
