/*
 * Copyright (c) 2007 innoSysTec (R) GmbH, Germany. All rights reserved.
 * Original author: Edmund Wagner
 * Creation date: 30.07.2007
 *
 * Source: $HeadURL$
 * Last changed: $LastChangedDate$
 * 
 * the unrar licence applies to all junrar source and binary distributions 
 * you are not allowed to use this source to re-create the RAR compression algorithm
 * 
 * Here some html entities which can be used for escaping javadoc tags:
 * "&":  "&#038;" or "&amp;"
 * "<":  "&#060;" or "&lt;"
 * ">":  "&#062;" or "&gt;"
 * "@":  "&#064;" 
 */
package com.innosystec.unrar.exception;

import java.io.IOException;

/**
 * DOCUMENT ME
 *
 * @author $LastChangedBy$
 * @version $LastChangedRevision$
 */
public class RarException extends IOException
{
	private String type;

	public RarException(Exception e)
	{
		super(e.toString());
		this.type = RarExceptionType.unkownError;
	}

	public RarException(RarException e)
	{
		super(e.toString());
		this.type = e.getType();
	}

	public RarException(String type)
	{
		super(type);
		this.type = type;
	}

	public static class RarExceptionType
	{
		public static final String

		notImplementedYet = "notImplementedYet",
		crcError = "crcError",
		notRarArchive = "notRarArchive",
		badRarArchive = "badRarArchive",
		unkownError = "unkownError",
		headerNotInArchive = "headerNotInArchive",
		wrongHeaderType = "wrongHeaderType",
		ioError = "ioError",
		rarEncryptedException = "rarEncryptedException";
	}

	public String getType()
	{
		return type;
	}

	public void setType(String type)
	{
		this.type = type;
	}
}
