package com.one;

import com.one.file.FileConnection;

public class ContainerEntry
{
	protected String name = "";
	protected int size = -1;
	protected long lastModified = -1;

	public FileConnection vfc;
	public boolean pureVirtual;

	public ContainerEntry()
	{
	}

	public ContainerEntry(String name)
	{
		setName(name);
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getName()
	{
		return name;
	}

	public void setSize(int size)
	{
		this.size = size;
	}

	public int getSize()
	{
		return size;
	}

	public void setLastModified(long time)
	{
		lastModified = time;
	}

	public long getLastModified()
	{
		return lastModified;
	}

	public boolean isDirectory()
	{
		return name.endsWith("/");
	}

	public String toString()
	{
		return "[" + Integer.toHexString(super.hashCode()).toUpperCase() + "][" + getClass().getName() + "] " + name;
	}

	public int hashCode()
	{
		return name.hashCode();
	}

	public boolean equals(Object obj)
	{
		if(obj == null)
		{
			return false;
		}

		if(getClass() != obj.getClass())
		{
			return false;
		}

		final ContainerEntry other = (ContainerEntry)obj;

		if((this.name == null) ? (other.name != null) : !this.name.equals(other.name))
		{
			return false;
		}

		return true;
	}
}