package com.one;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Библиотека для создания иерархических списков файлов.
 *
 * Папка в списке представляет собой Hashtable,
 * в которой ключами являются имена файлов в этой папке (без путей),
 * а элементами могут являться:
 * для дочерних папок - другая Hashtable,
 * для обычных файлов - new Object().
 */
public class Directory
{
	public static void addFile(Hashtable directory, String file)
	{
		int index = file.indexOf('/') + 1;

		if(index > 0)
		{
			String filepath = file.substring(0, index);
			String filename = file.substring(index);

			Hashtable subdirectory = (Hashtable)directory.get(filepath);

			if(subdirectory == null)
			{
				subdirectory = new Hashtable();
				directory.put(filepath, subdirectory);
			}

			if(filename.length() > 0)
			{
				addFile(subdirectory, filename);
			}
		}
		else
		{
			directory.put(file, new Object());
		}
	}

	public static void deleteFile(Hashtable directory, String file)
	{
		int index = file.indexOf('/') + 1;

		if(index > 0)
		{
			String filepath = file.substring(0, index);
			String filename = file.substring(index);

			if(filename.length() > 0)
			{
				Hashtable subdirectory = (Hashtable)directory.get(filepath);

				if(subdirectory == null)
				{
					return;
				}

				deleteFile(subdirectory, filename);
			}
			else
			{
				directory.remove(filepath);
			}
		}
		else
		{
			directory.remove(file);
		}
	}

	public static void renameFile(Hashtable files, String path, String oldname, String newname)
	{
		deleteFile(files, oldname);
		addFile(files, newname);

		/*
		if(path == null)
		{
			char[] ocs = oldname.toCharArray();
			char[] ncs = newname.toCharArray();

			int len = Math.min(ocs.length, ncs.length);

			for(int i = 0; i < len; i++)
			{
				if(ncs[i] != ocs[i])
				{
					path = oldname.substring(0, i);

					oldname = oldname.substring(i);
					newname = newname.substring(i);

					break;
				}
			}

			if(path == null)
			{
				return;
			}
		}

		Hashtable directory = files;
		int index;

		while(path.length() > 0)
		{
			index = path.indexOf('/') + 1;
			directory = (Hashtable)directory.get(path.substring(0, index));

			if(directory == null)
			{
				return;
			}

			path = path.substring(index);
		}

		directory.put(newname, directory.remove(oldname));
		*/
	}

	public static Enumeration listFiles(Hashtable files, String path)
	{
		if(path == null || path.length() == 0)
		{
			return files.keys();
		}
		else
		{
			if(!path.endsWith("/"))
			{
				path = path + "/";
			}

			Hashtable directory = files;
			int index;

			while(true)
			{
				index = path.indexOf('/') + 1;
				directory = (Hashtable)directory.get(path.substring(0, index));

				if(directory == null)
				{
					return null;
				}

				path = path.substring(index);

				if(path.length() == 0)
				{
					return directory.keys();
				}
			}
		}
	}

	public static boolean fileExists(Hashtable files, String file)
	{
		Hashtable directory = files;
		int index;

		while(true)
		{
			index = file.indexOf('/') + 1;

			if(index > 0)
			{
				directory = (Hashtable)directory.get(file.substring(0, index));

				if(directory == null)
				{
					return false;
				}

				file = file.substring(index);

				if(file.length() == 0)
				{
					return true;
				}
			}
			else
			{
				return directory.containsKey(file);
			}
		}
	}
}
