package com.one;

import javax.microedition.lcdui.*;

public class DisplayManager implements CommandListener
{
	protected Display dsp;
	protected Renderer rn;
	protected boolean renderMode;
	protected Object next;
	
	public DisplayManager(Display d)
	{
		dsp = d;
		rn = new Renderer(); // new AsyncRenderer();
		renderMode = false;
	}
	
	public void commandAction(Command c, Displayable d)
	{
		if(next != null)
		{
			setCurrent(next);
			next = null;
		}
	}
	
	public Renderer getRenderer()
	{
		return rn;
	}
	
	public void setCurrent(Object obj)
	{
		if(obj instanceof ErrScreen.ObjectWrap)
		{
			obj = ((ErrScreen.ObjectWrap)obj).object;
		}
		else if(getCurrent() instanceof ErrScreen)
		{
			ErrScreen.getInstance().setNextDisplayable(obj);
			return;
		}

		if(obj instanceof PaintableObject)
		{
			rn.setCurrent((PaintableObject)obj);
			
			if(!renderMode)
			{
				dsp.setCurrent(rn);
				renderMode = true;
			}
		}
		else
		{
			dsp.setCurrent((Displayable)obj);
			renderMode = false;
		}
	}
	
	public void setCurrent(AutoAdvanceScreen aas, Object obj)
	{
		setCurrent(aas);
		
		if(aas.finiteTimeout())
		{
			next = obj;
			
			aas.setCommandListener(this);
			(new Thread(aas, "DisplayManager/AutoAdvance")).start();
		}
	}
	
	public void setCurrent(Alert al, Object obj)
	{
		if(obj instanceof PaintableObject)
		{
			rn.setCurrent((PaintableObject)obj);
			dsp.setCurrent(al, rn);
		}
		else
		{
			dsp.setCurrent(al, (Displayable)obj);
		}
		
		renderMode = false;
	}
	
	public Object getCurrent()
	{
		if(renderMode)
		{
			return rn.getCurrent();
		}
		else
		{
			return dsp.getCurrent();
		}
	}
	
	public void callSerially(Runnable r)
	{
		dsp.callSerially(r);
	}
	
	public boolean flashBacklight(int duration)
	{
		return dsp.flashBacklight(duration);
	}
	
	public int getBestImageHeight(int imageType)
	{
		return dsp.getBestImageHeight(imageType);
	}
	
	public int getBestImageWidth(int imageType)
	{
		return  dsp.getBestImageWidth(imageType);
	}
	
	public int getBorderStyle(boolean highlighted)
	{
		return dsp.getBorderStyle(highlighted);
	}
	
	public int getColor(int colorSpecifier)
	{
		return dsp.getColor(colorSpecifier);
	}
	
	public boolean isColor()
	{
		return dsp.isColor();
	}
	
	public int numAlphaLevels()
	{
		return dsp.numAlphaLevels();
	}
	
	public int numColors()
	{
		return dsp.numColors();
	}
	
	public void setCurrentItem(Item item)
	{
		dsp.setCurrentItem(item);
	}
	
	public boolean vibrate(int duration)
	{
		return dsp.vibrate(duration);
	}
}
