package com.one;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ExtGraphics
{
	protected Graphics graphics;
	protected AbstractFont font;

	public ExtGraphics(Graphics graphics)
	{
		this.graphics = graphics;
		setFont(AbstractFont.getDefaultFont());
	}

	public Graphics getGraphics()
	{
		return graphics;
	}

	public void clipRect(int x, int y, int width, int height)
	{
		graphics.clipRect(x, y, width, height);
	}

	public void copyArea(int x_src, int y_src, int width, int height, int x_dest, int y_dest, int anchor)
	{
		graphics.copyArea(x_src, y_src, width, height, x_dest, y_dest, anchor);
	}

	public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle)
	{
		graphics.drawArc(x, y, width, height, startAngle, arcAngle);
	}

	public void drawChar(char character, int x, int y, int anchor)
	{
		font.drawChar(graphics, character, x, y, anchor);
	}

	public void drawChars(char[] data, int offset, int length, int x, int y, int anchor)
	{
		font.drawChars(graphics, data, offset, length, x, y, anchor);
	}

	public void drawImage(Image img, int x, int y, int anchor)
	{
		graphics.drawImage(img, x, y, anchor);
	}

	public void drawLine(int x1, int y1, int x2, int y2)
	{
		graphics.drawLine(x1, y1, x2, y2);
	}

	public void drawRect(int x, int y, int width, int height)
	{
		graphics.drawRect(x, y, width, height);
	}

	public void drawRegion(Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor)
	{
		graphics.drawRegion(src, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
	}

	public void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha)
	{
		graphics.drawRGB(rgbData, offset, scanlength, x, y, width, height, processAlpha);
	}

	public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight)
	{
		graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
	}

	public void drawString(String str, int x, int y, int anchor)
	{
		font.drawString(graphics, str, x, y, anchor);
	}

	public void drawSubstring(String str, int offset, int len, int x, int y, int anchor)
	{
		font.drawSubstring(graphics, str, offset, len, x, y, anchor);
	}

	public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle)
	{
		graphics.fillArc(x, y, width, height, startAngle, arcAngle);
	}

	public void fillRect(int x, int y, int width, int height)
	{
		graphics.fillRect(x, y, width, height);
	}

	public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight)
	{
		graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
	}

	public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3)
	{
		graphics.fillTriangle(x1, y1, x2, y2, x3, y3);
	}

	public int getBlueComponent()
	{
		return graphics.getBlueComponent();
	}

	public int getClipHeight()
	{
		return graphics.getClipHeight();
	}

	public int getClipWidth()
	{
		return graphics.getClipWidth();
	}

	public int getClipX()
	{
		return graphics.getClipX();
	}

	public int getClipY()
	{
		return graphics.getClipY();
	}

	public int getColor()
	{
		return graphics.getColor();
	}

	public int getDisplayColor(int color)
	{
		return graphics.getDisplayColor(color);
	}

	public AbstractFont getFont()
	{
		return font;
	}

	public int getGrayScale()
	{
		return graphics.getGrayScale();
	}

	public int getGreenComponent()
	{
		return graphics.getGreenComponent();
	}

	public int getRedComponent()
	{
		return graphics.getRedComponent();
	}

	public int getStrokeStyle()
	{
		return graphics.getStrokeStyle();
	}

	public int getTranslateX()
	{
		return graphics.getTranslateX();
	}

	public int getTranslateY()
	{
		return graphics.getTranslateY();
	}

	public void setClip(int x, int y, int width, int height)
	{
		graphics.setClip(x, y, width, height);
	}

	public void setColor(int RGB)
	{
		graphics.setColor(RGB);
	}

	public void setColor(int red, int green, int blue)
	{
		graphics.setColor(red, green, blue);
	}

	public void setFont(AbstractFont font)
	{
		this.font = font;
	}

	public void setGrayScale(int value)
	{
		graphics.setGrayScale(value);
	}

	public void setStrokeStyle(int style)
	{
		graphics.setStrokeStyle(style);
	}

	public void translate(int x, int y)
	{
		graphics.translate(x, y);
	}
}