package com.one;

import java.util.Random;

/**
 * Генератор псевдослучайных чисел.
 * Используется алгоритм Джорджа Марсаглии "Xorshift 128".
 */
public class ExtRandom extends Random
{
	protected static int[] bitmask = new int[33];
	
	static
	{
		bitmask[32] = 0xFFFFFFFF;
		
		for(int i = 31; i >= 0; i--)
		{
			bitmask[i] = bitmask[i + 1] >>> 1;
		}
	}
	
	protected int t, x, y, z, w;
	protected int mx, my, mz, mw;
	
	public ExtRandom()
	{
		super();
	}
	
	public ExtRandom(long seed)
	{
		super(seed);
	}
	
	protected int next(int bits)
	{
		t = (x ^ (x << 11));
		x = y;
		y = z;
		z = w;
		w = (w ^ (w >>> 19)) ^ (t ^ (t >>> 8));
		
		return w & bitmask[bits];
	}
	
	public void setSeed(long seed)
	{
		x = (int)seed;
		
		y = 362436069;
		z = 521288629;
		w = 88675123;
		
		mark();
	}
	
	public void mark()
	{
		mx = x;
		my = y;
		mz = z;
		mw = w;
	}
	
	public void reset()
	{
		x = mx;
		y = my;
		z = mz;
		w = mw;
	}
}
