package com.one;

public abstract class ExtThread implements Runnable
{
	protected boolean running;
	protected Thread t;

	public void start()
	{
		running = true;
		t = new Thread(this, "ExtThread/Task");
		t.start();
	}

	public void stop()
	{
		running = false;
	}

	public boolean isAlive()
	{
		return running;
	}

	public void join() throws InterruptedException
	{
		if(running && t != null)
		{
			t.join();
		}
	}

	public abstract void run();
}
