package com.one;

import com.classpath.util.Characters;
import com.one.file.Connector;
import com.one.file.FileConnection;
import java.util.Enumeration;
import java.util.Vector;

public class FileSystemObject
{
	protected String currentPath;
	protected Exception lastError;
	
	public FileSystemObject()
	{
		currentPath = null;
	}
	
	public FileSystemObject(String initialPath)
	{
		currentPath = initialPath;
	}
	
	public Enumeration list()
	{
		lastError = null;
		
		try
		{
			if(currentPath == null)
			{
				return Connector.listRoots();
			}
			else
			{
				FileConnection fc = (FileConnection)Connector.open("file:///" + currentPath, Connector.READ);
				Enumeration e = fc.list();
				fc.close();
				
				return e;
			}
		}
		catch(Exception x)
		{
			lastError = x;
			return null;
		}
	}
	
	public Enumeration list(String ext, boolean folders)
	{
		lastError = null;
		
		try
		{
			if(currentPath == null)
			{
				return Connector.listRoots();
			}
			else
			{
				FileConnection fc = (FileConnection)Connector.open("file:///" + currentPath, Connector.READ);
				Enumeration e = fc.list();
				fc.close();
				
				Vector v = new Vector();
				String s;
				
				if(ext == null)
				{
					ext = "";
				}
				
				if(folders)
				{
					while(e.hasMoreElements())
					{
						s = (String)e.nextElement();
						
						if(s.endsWith("/") || s.toLowerCase().endsWith(ext))
						{
							v.addElement(s);
						}
					}
				}
				else
				{
					while(e.hasMoreElements())
					{
						s = (String)e.nextElement();
						
						if(s.toLowerCase().endsWith(ext))
						{
							v.addElement(s);
						}
					}
				}
				
				return v.elements();
			}
		}
		catch(Exception x)
		{
			lastError = x;
			return null;
		}
	}
	
	public void changeDir(String nextDir)
	{
		if(nextDir != null)
		{
			if(currentPath != null)
			{
				currentPath += nextDir;
			}
			else
			{
				currentPath = nextDir;
			}
		}
		else if(currentPath != null)
		{
			currentPath = currentPath.substring(0, currentPath.length() - 1);
			int index = currentPath.lastIndexOf('/');
			
			if(index >= 0)
			{
				currentPath = currentPath.substring(0, index + 1);
			}
			else
			{
				currentPath = null;
			}
		}
	}
	
	public void resetPath()
	{
		currentPath = null;
	}
	
	public FileConnection openFileConnection(String file)
	{
		lastError = null;
		
		try
		{
			return (FileConnection)Connector.open("file:///" + currentPath + file);
		}
		catch(Exception x)
		{
			lastError = x;
			return null;
		}
	}
	
	public String getCurrentPath()
	{
		return currentPath;
	}
	
	public Exception getLastError()
	{
		return lastError;
	}
	
	public static Enumeration sortFileList(Enumeration list)
	{
		if(list == null)
		{
			return null;
		}
		
		Vector vdirs = new Vector();
		Vector vfiles = new Vector();
		
		String s;
		
		while(list.hasMoreElements())
		{
			s = (String)list.nextElement();
			
			if(s.endsWith("/"))
			{
				vdirs.addElement(s);
			}
			else
			{
				vfiles.addElement(s);
			}
		}
		
		if(vdirs.size() > 0)
		{
			quickSort(vdirs, 0, vdirs.size() - 1);
		}
		
		if(vfiles.size() > 0)
		{
			quickSort(vfiles, 0, vfiles.size() - 1);
		}
		
		CompoundEnumeration result = new CompoundEnumeration();
		result.addEnumeration(vdirs.elements());
		result.addEnumeration(vfiles.elements());
		
		return result;
	}
	
	public static void quickSort(Vector arr, int first, int last)
	{
		String p = Characters.toLowerCase((String)arr.elementAt((last - first) / 2 + first));
		String temp;
		int i = first, j = last;

		while(i <= j)
		{
			while(Characters.toLowerCase((String)arr.elementAt(i)).compareTo(p) < 0 && i <= last)
			{
				i++;
			}

			while(Characters.toLowerCase((String)arr.elementAt(j)).compareTo(p) > 0 && j >= first)
			{
				j--;
			}

			if(i <= j)
			{
				temp = ((String)arr.elementAt(i));
				arr.setElementAt(arr.elementAt(j), i);
				arr.setElementAt(temp, j);

				i++;
				j--;
			}
		}

		if(j > first)
		{
			quickSort(arr, first, j);
		}

		if(i < last)
		{
			quickSort(arr, i, last);
		}
	}
}