package com.one;

import com.vmx.*;

/**
 * Запись INI.
 * Оставлена, по большому счету, только для совместимости
 * (в тот день программисту было лень писать обновленный код).
 */
public class IniRecord
{
	public String key;
	public String value;
	
	public IniRecord(String key, String value)
	{
		this.key = key;
		this.value = value;
	}
	
	public static IniRecord getNextRecord(InputStreamDecoder isd)
	{
		try
		{
			String line = isd.readIniLine();
			
			if(line == null)
			{
				return null;
			}
			
			int index = line.indexOf('=');
			
			if(index >= 0)
			{
				return new IniRecord(line.substring(0, index).trim(), line.substring(index + 1).trim());
			}
			else
			{
				return new IniRecord(line, line);
			}
		}
		catch(Exception e)
		{
			ErrScreen.showErrMsg(99, e);
			return null;
		}
	}
}
