package com.one;

import java.util.EmptyStackException;

public class IntStack
{
	public static final int DELTA = 4096;
	
	protected int[] data;
	protected int index;
	
	public IntStack()
	{
		clear();
	}
	
	public void push(int value)
	{
		if(index >= data.length - 1)
		{
			try
			{
				int[] temp = new int[data.length + DELTA];
				System.arraycopy(data, 0, temp, 0, data.length);
				data = temp;
			}
			catch(OutOfMemoryError oome)
			{
				throw new StackOverflowException();
			}
		}
		
		data[++index] = value;
	}
	
	public int pop()
	{
		if(index < 0)
		{
			throw new EmptyStackException();
		}
		
		if(index + (DELTA << 1) <= data.length - 1)
		{
			try
			{
				int[] temp = new int[data.length - DELTA];
				System.arraycopy(data, 0, temp, 0, temp.length);
				data = temp;
			}
			catch(OutOfMemoryError oome)
			{
			}
		}
		
		return data[index--];
	}
	
	public void clear()
	{
		data = new int[0];
		index = -1;
	}
	
	public boolean empty()
	{
		return index < 0;
	}
}
