package com.one;

//#if NokiaUI == "true"

import java.util.Timer;
import java.util.TimerTask;
import com.nokia.mid.ui.DeviceControl;
import com.vmx.AuxClass;

public class LightControl
{
	public static final int LEVEL = 100;
	public static final int INTERVAL = 1000;

	protected static Timer timer;

	public static void startLightControl(boolean enabled)
	{
		if(!AuxClass.classExists("com.nokia.mid.ui.DeviceControl"))
		{
			return;
		}

		if(timer != null)
		{
			timer.cancel();
			timer = null;
		}

		if(enabled)
		{
			TimerTask task = new TimerTask()
			{
				public void run()
				{
					DeviceControl.setLights(0, LEVEL);
				}
			};

			timer = new Timer();
			timer.scheduleAtFixedRate(task, INTERVAL, INTERVAL);
		}
	}
}

//#else
//#
//# public class LightControl
//# {
//# 	public static void startLightControl(boolean enabled)
//# 	{
//# 	}
//# }
//#
//#endif