package com.one;

import com.classpath.util.Characters;
import com.vmx.AuxClass;
import java.util.Calendar;

public class NameTemplate
{
	public static final String NAME = "[N]";
	public static final String EXTENSION = "[E]";

	public static final String COUNTER = "[C]";
	
	public static final int CASE_UNCHANGED = 0;
	public static final int ALL_LOWERCASE = 1;
	public static final int ALL_UPPERCASE = 2;
	public static final int LINE_FIRST_UPPERCASE = 3;
	public static final int WORD_FIRST_UPPERCASE = 4;

	public static final String WORD_BOUNDS = " \t_.!";

	protected String template;

	protected String find, replace;

	protected int counter;
	protected int step, numdigits;

	protected int targetcase;

	public NameTemplate(String template)
	{
		this.template = template;

		setCounter(1, 1, 1);
		setReplace(null, null);
		setTargetCase(CASE_UNCHANGED);
	}

	public void setCounter(int value, int step, int numdigits)
	{
		this.counter = value;
		this.step = step;
		this.numdigits = numdigits;
	}

	public void setReplace(String find, String replace)
	{
		if(find == null)
		{
			find = "";
		}

		this.find = find;
		this.replace = replace;
	}

	public void setTargetCase(int targetcase)
	{
		this.targetcase = targetcase;
	}

	public String getNewName(String filename)
	{
		int index = filename.lastIndexOf('.');
		String name, ext;

		if(index >= 0)
		{
			name = filename.substring(0, index);
			ext = filename.substring(index + 1);
		}
		else
		{
			name = filename;
			ext = "";
		}
		
		Calendar cal = Calendar.getInstance();
		
		String year = AuxClass.integerToString(cal.get(Calendar.YEAR), 2);
		year = year.substring(year.length() - 2);

		filename = template;
		
		filename = TextProcessor.replaceText(filename, NAME, name);
		filename = TextProcessor.replaceText(filename, EXTENSION, ext);
		
		filename = TextProcessor.replaceText(filename, COUNTER, AuxClass.integerToString(counter, numdigits));
		counter += step;
		
		filename = TextProcessor.replaceText(filename, AuxClass.YEAR, AuxClass.integerToString(cal.get(Calendar.YEAR), 4));
		filename = TextProcessor.replaceText(filename, AuxClass.YEAR_SHORT, year);
		filename = TextProcessor.replaceText(filename, AuxClass.MONTH, AuxClass.integerToString(cal.get(Calendar.MONTH) + 1, 2));
		filename = TextProcessor.replaceText(filename, AuxClass.DAY_OF_MONTH, AuxClass.integerToString(cal.get(Calendar.DAY_OF_MONTH), 2));

		filename = TextProcessor.replaceText(filename, AuxClass.HOUR_OF_DAY, AuxClass.integerToString(cal.get(Calendar.HOUR_OF_DAY), 2));
		filename = TextProcessor.replaceText(filename, AuxClass.MINUTE, AuxClass.integerToString(cal.get(Calendar.MINUTE), 2));
		filename = TextProcessor.replaceText(filename, AuxClass.SECOND, AuxClass.integerToString(cal.get(Calendar.SECOND), 2));

		if(find.length() > 0)
		{
			filename = TextProcessor.replaceText(filename, find, replace);
		}

		switch(targetcase)
		{
			case ALL_LOWERCASE:
				filename = Characters.toLowerCase(filename);
				break;

			case ALL_UPPERCASE:
				filename = Characters.toUpperCase(filename);
				break;

			case LINE_FIRST_UPPERCASE:
				filename = Characters.toUpperCase(filename.substring(0, 1)) + Characters.toLowerCase(filename.substring(1));
				break;

			case WORD_FIRST_UPPERCASE:
				char[] cs = Characters.toLowerCase(filename).toCharArray();
				cs[0] = Characters.toUpperCase(cs[0]);

				int max = filename.lastIndexOf('.');
				
				if(max < 0)
				{
					max = cs.length - 1;
				}

				for(index = 1; index < max; index++)
				{
					if(WORD_BOUNDS.indexOf(cs[index]) >= 0) // Characters.isWhitespace(cs[index]))
					{
						cs[index + 1] = Characters.toUpperCase(cs[index + 1]);
					}
				}

				filename = new String(cs);
				break;
		}

		return filename;
	}
}