package com.one;

import com.vmx.ProgressCallback;
import filemanager.Buffer;

public abstract class Operation implements Runnable
{
	protected ProgressCallback callback;
	protected StringBuffer errors;
	protected boolean enabled;
	protected boolean clear;
	
	public Operation()
	{
		errors = new StringBuffer();
		enabled = true;
		clear = true;
	}

	public void start()
	{
		Buffer.startOperation(this);
	}
	
	public void stop()
	{
		enabled = false;
		callback.setCancelFlag(true);
	}
	
	public void setProgressCallback(ProgressCallback callback)
	{
		this.callback = callback;
		callback.setCancelFlag(false);
	}
	
	public String getErrors()
	{
		return errors.toString();
	}
	
	protected void logError(Throwable t)
	{
		t.printStackTrace();
		
		errors.append(t);
		errors.append('\n');
		errors.append('\n');
	}
	
	public boolean getClearFlag()
	{
		return clear;
	}

	public void run()
	{
	}
}
