package com.one;

public abstract class PaintableObject
{
	public static final int KEY_NUM0 = 48;
	public static final int KEY_NUM1 = 49;
	public static final int KEY_NUM2 = 50;
	public static final int KEY_NUM3 = 51;
	public static final int KEY_NUM4 = 52;
	public static final int KEY_NUM5 = 53;
	public static final int KEY_NUM6 = 54;
	public static final int KEY_NUM7 = 55;
	public static final int KEY_NUM8 = 56;
	public static final int KEY_NUM9 = 57;
	public static final int KEY_STAR = 42;
	public static final int KEY_POUND = 35;
	
	public static final int UP = 1;
	public static final int LEFT = 2;
	public static final int RIGHT = 5;
	public static final int DOWN = 6;
	public static final int FIRE = 8;
	public static final int GAME_A = 9;
	public static final int GAME_B = 10;
	public static final int GAME_C = 11;
	public static final int GAME_D = 12;
	
	private static Renderer renderer;
	
	public static void setRenderer(Renderer rn)
	{
		renderer = rn;
	}
	
	public static Renderer getRenderer()
	{
		return renderer;
	}
	
	public void repaint()
	{
		renderer.repaint(this);
	}
	
	public void repaint(int x, int y, int width, int height)
	{
		renderer.repaint(this, x, y, width, height);
	}
	
	public void serviceRepaints()
	{
		renderer.serviceRepaints(this);
	}
	
	public void setFullScreenMode(boolean mode)
	{
		renderer.setFullScreenMode(this, mode);
	}
	
	public int getWidth()
	{
		return renderer.getWidth();
	}
	
	public int getHeight()
	{
		return renderer.getHeight();
	}
	
	public int getGameAction(int keyCode)
	{
		return renderer.getGameAction(keyCode);
	}
	
	public int getKeyCode(int gameAction)
	{
		return renderer.getKeyCode(gameAction);
	}
	
	public String getKeyName(int keyCode)
	{
		return renderer.getKeyName(keyCode);
	}
	
	public boolean hasPointerEvents()
	{
		return renderer.hasPointerEvents();
	}
	
	public boolean hasPointerMotionEvents()
	{
		return renderer.hasPointerMotionEvents();
	}
	
	public boolean hasRepeatEvents()
	{
		return renderer.hasRepeatEvents();
	}
	
	public boolean isDoubleBuffered()
	{
		return renderer.isDoubleBuffered();
	}
	
	public void showNotify()
	{
	}
	
	public void hideNotify()
	{
	}
	
	public void keyPressed(int keyCode)
	{
	}
	
	public void keyReleased(int keyCode)
	{
	}
	
	public void keyRepeated(int keyCode)
	{
	}
	
	public abstract void paint(ExtGraphics g);
	
	public void pointerDragged(int x, int y)
	{
	}
	
	public void pointerPressed(int x, int y)
	{
	}
	
	public void pointerReleased(int x, int y)
	{
	}
	
	public void sizeChanged(int w, int h)
	{
	}
}
