package com.one;

import com.vmx.AuxClass;
import java.util.Enumeration;
import java.util.Vector;

public class PlayList
{
	protected String[] playlist;
	protected int selectedIndexNormal, selectedIndexRandom;
	protected int[] randomRemapIndices;

	protected class ArraySearchThread extends ExtThread
	{
		public String element;

		public void run()
		{
			for(int i = 0; (i < playlist.length) && running; i++)
			{
				if(playlist[i].equals(element))
				{
					selectedIndexNormal = i;
					break;
				}
			}

			running = false;
			rst.start();
		}
	};

	protected class RemapSearchThread extends ExtThread
	{
		public void run()
		{
			for(int i = 0; (i < playlist.length) && running; i++)
			{
				if(randomRemapIndices[i] == selectedIndexNormal)
				{
					selectedIndexRandom = i;
					break;
				}
			}

			running = false;
		}
	};

	protected ArraySearchThread ast = new ArraySearchThread();
	protected RemapSearchThread rst = new RemapSearchThread();
	
	public PlayList(Enumeration newlist)
	{
		Vector v = new Vector();

		while(newlist.hasMoreElements())
		{
			v.addElement(newlist.nextElement());
		}

		playlist = new String[v.size()];
		v.copyInto(playlist);

		randomRemapIndices = AuxClass.randomSequence(0, playlist.length - 1, -1);

		selectedIndexNormal = 0;
		rst.start();
	}

	public PlayList(String[] newlist)
	{
		playlist = newlist;
		randomRemapIndices = AuxClass.randomSequence(0, playlist.length - 1, -1);

		selectedIndexNormal = 0;
		rst.start();
	}

	public PlayList(String file)
	{
		playlist = new String[1];
		playlist[0] = file;
		selectedIndexNormal = 0;

		randomRemapIndices = new int[1];
		randomRemapIndices[0] = 0;
		selectedIndexRandom = 0;
	}

	public void selectElement(String element)
	{
		if(getCurrentElement().equals(element))
		{
			return;
		}

		ast.element = element;
		ast.start();
	}

	public void waitForElementFound()
	{
		if(ast.isAlive())
		{
			try
			{
				ast.join();
			}
			catch(InterruptedException ie)
			{
			}
		}

		if(rst.isAlive())
		{
			try
			{
				rst.join();
			}
			catch(InterruptedException ie)
			{
			}
		}
	}

	public void cancelSearch()
	{
		ast.stop();
		rst.stop();
	}

	public void nextElement(boolean shuffle)
	{
		if(ast.isAlive())
		{
			try
			{
				ast.join();
			}
			catch(InterruptedException ie)
			{
			}
		}

		if(shuffle)
		{
			if(rst.isAlive())
			{
				try
				{
					rst.join();
				}
				catch(InterruptedException ie)
				{
				}
			}

			if(++selectedIndexRandom >= playlist.length)
			{
				selectedIndexRandom = 0;
			}

			selectedIndexNormal = randomRemapIndices[selectedIndexRandom];
		}
		else
		{
			if(++selectedIndexNormal >= playlist.length)
			{
				selectedIndexNormal = 0;
			}

			rst.start();
		}
	}

	public void prevElement(boolean shuffle)
	{
		if(ast.isAlive())
		{
			try
			{
				ast.join();
			}
			catch(InterruptedException ie)
			{
			}
		}

		if(shuffle)
		{
			if(rst.isAlive())
			{
				try
				{
					rst.join();
				}
				catch(InterruptedException ie)
				{
				}
			}
			
			if(--selectedIndexRandom < 0)
			{
				selectedIndexRandom = playlist.length - 1;
			}

			selectedIndexNormal = randomRemapIndices[selectedIndexRandom];
		}
		else
		{
			if(--selectedIndexNormal < 0)
			{
				selectedIndexNormal = playlist.length - 1;
			}

			rst.start();
		}
	}

	public String getElement(int index)
	{
		if(index >= 0 && index < playlist.length)
		{
			return playlist[index];
		}
		else
		{
			return null;
		}
	}

	public String getCurrentElement()
	{
		return playlist[getCurrentIndex()];
	}

	public int getCurrentIndex()
	{
		if(ast.isAlive())
		{
			try
			{
				ast.join();
			}
			catch(InterruptedException ie)
			{
			}
		}

		return selectedIndexNormal;
	}
}
