package com.one;

import com.vmx.ProgressCallback;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class ProgressBar
{
	protected static DisplayManager manager;

	protected static Object displayable;
	protected static Object parent;

	protected static class DefaultProgressDisplayable extends Form implements ProgressCallback
	{
		protected Gauge g;
		protected StringItem si;
		protected boolean percentmode;
		protected boolean cancelflag;

		public DefaultProgressDisplayable()
		{
			super("Please, wait...");

			percentmode = true;

			g = new Gauge("0%", false, 1, 0);
			g.setLayout(Item.LAYOUT_EXPAND);

			si = new StringItem(null, "");
			si.setLayout(Item.LAYOUT_EXPAND);

			append(g);
			append(si);
		}

		protected void updateLabel()
		{
			if(percentmode)
			{
				g.setLabel(Integer.toString(g.getValue() * 100 / g.getMaxValue()) + "%");
			}
			else
			{
				g.setLabel(Integer.toString(g.getValue()) + " / " + Integer.toString(g.getMaxValue()));
			}
		}

		public void setMax(int max)
		{
			if(max < 1)
			{
				max = 1;
			}

			g.setMaxValue(max);
			updateLabel();
		}

		public void setProgress(int progress)
		{
			if(g.getMaxValue() < progress)
			{
				g.setMaxValue(progress);
			}

			g.setValue(progress);
			updateLabel();
		}

		public void rise(int plus)
		{
			setMax(getMax() + plus);
		}

		public void progress(int plus)
		{
			setProgress(getProgress() + plus);
		}

		public void setText(String text)
		{
			si.setText(text);
		}

		public int getMax()
		{
			return g.getMaxValue();
		}

		public int getProgress()
		{
			return g.getValue();
		}

		public String getText()
		{
			return si.getText();
		}

		public void setPercentMode(boolean mode)
		{
			percentmode = mode;
		}

		public void setCancelFlag(boolean flag)
		{
			cancelflag = flag;
		}

		public boolean getCancelFlag()
		{
			return cancelflag;
		}
	}

	public static void setDisplayManager(DisplayManager dsp)
	{
		manager = dsp;
	}

	static
	{
		setDisplayable(null);
	}

	public static void setDisplayable(Object object)
	{
		if(object != null)
		{
			if(!(object instanceof Displayable || object instanceof PaintableObject))
			{
				throw new IllegalArgumentException("No displayable");
			}

			if(!(object instanceof ProgressCallback))
			{
				throw new IllegalArgumentException("No progress callback");
			}

			displayable = object;
		}
		else
		{
			displayable = new DefaultProgressDisplayable();
		}
	}

	public static ProgressCallback getProgressCallback()
	{
		return (ProgressCallback)displayable;
	}

	public static void show()
	{
		if(manager != null && manager.getCurrent() != displayable)
		{
			parent = manager.getCurrent();
			manager.setCurrent(displayable);
		}
	}

	public static void hide()
	{
		if(manager != null && manager.getCurrent() == displayable)
		{
			manager.setCurrent(parent);
		}
	}
}
