package com.one;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SystemFont extends AbstractFont
{
	protected Font font;

	protected int height, baseline;
//	protected byte[][] widths = new byte[256][];

	public SystemFont(int face, int style, int size)
	{
		this(Font.getFont(face, style, size));
	}

	public SystemFont(Font font)
	{
		this.font = font;

		height = font.getHeight();
		baseline = font.getBaselinePosition();

		face = font.getFace();
		size = font.getSize();
		style = font.getStyle();
	}

	public int getBaselinePosition()
	{
		return baseline;
	}

	public int getHeight()
	{
		return height;
	}

	public int charWidth(char ch)
	{
		return font.charWidth(ch);

//		int hi = ch >>> 8;
//		int lo = ch & 0xFF;
//
//		if(widths[hi] == null)
//		{
//			widths[hi] = new byte[256];
//
//			for(int i = 0; i < 256; i++)
//			{
//				widths[hi][i] = -1;
//			}
//		}
//
//		if(widths[hi][lo] == -1)
//		{
//			widths[hi][lo] = (byte)font.charWidth(ch);
//		}
//
//		return ((int)widths[hi][lo]) & 0xFF;
	}

	public int charsWidth(char[] ch, int offset, int length)
	{
		return font.charsWidth(ch, offset, length);
	}

	public int stringWidth(String str)
	{
		return font.stringWidth(str);
	}

	public void drawChar(Graphics g, char character, int x, int y)
	{
		g.setFont(font);
		g.drawChar(character, x, y, Graphics.LEFT | Graphics.TOP);
	}

	public void drawChars(Graphics g, char[] data, int offset, int length, int x, int y, int anchor)
	{
		g.setFont(font);
		g.drawChars(data, offset, length, x, y, anchor);
	}

	public void drawString(Graphics g, String str, int x, int y, int anchor)
	{
		g.setFont(font);
		g.drawString(str, x, y, anchor);
	}
}