package com.one;

import javax.microedition.lcdui.*;

/**
 * Служебный класс.
 */
public class TestCanvas extends PaintableObject implements Runnable
{
	protected String key, fps;
	protected AbstractFont font;
	protected int x, y;
	protected boolean flag;
	protected long time, prevtime, delta;
	protected int framecount;
	
	public TestCanvas()
	{
		setFullScreenMode(true);
		
		font = AbstractFont.getDefaultFont();
		
		key = "0";
		fps = "0 FPS";
		
		x = getWidth() / 2;
		y = (getHeight() - font.getHeight()) / 2;
	}
	
	public void keyPressed(int keyCode)
	{
		key = Integer.toString(keyCode); // + " (" + getKeyName(keyCode) + ")";
		
		repaint();
		serviceRepaints();
	}
	
	public void showNotify()
	{
		flag = true;
		(new Thread(this, "TestCanvas/Repaint")).start();
	}
	
	public void hideNotify()
	{
		flag = false;
	}
	
	public void paint(ExtGraphics g)
	{
		g.setColor(0x008080);
		g.fillRect(0, 0, getWidth(), getHeight());
		
		g.setColor(0xE0E0E0);
		g.setFont(font);
		
		g.drawString(key, 0, 0, Graphics.LEFT | Graphics.TOP);
		g.drawString(fps, getWidth(), 0, Graphics.RIGHT | Graphics.TOP);
		g.drawString(Long.toString(time, 10).toUpperCase(), x, y, Graphics.HCENTER | Graphics.TOP);
		
		time = System.currentTimeMillis();
		delta = time - prevtime;
		framecount++;
		
		if(delta >= 1000)
		{
			fps = Long.toString(framecount * 1000 / delta, 10).toUpperCase() + " FPS";
			prevtime = time;
			framecount = 0;
		}
	}
	
	public void run()
	{
		while(flag)
		{
			repaint();
			serviceRepaints();
			
			Thread.yield();
		}
	}
}
