package com.one.file;

import java.io.IOException;
import java.io.InputStream;

/**
 * InputStream, основанный на FileConnection.
 * При закрытии автоматически закрывает базовый файл.
 */
public class AFCInputStream extends InputStream
{
	protected FileConnection fc;
	protected InputStream is;

	public AFCInputStream(FileConnection fc) throws IOException
	{
		this.fc = fc;
		is = fc.openInputStream();
	}

	public int available() throws IOException
	{
		return is.available();
	}

	public void close() throws IOException
	{
		is.close();
		fc.close();
	}

	public void mark(int readLimit)
	{
		is.mark(readLimit);
	}

	public boolean markSuported()
	{
		return is.markSupported();
	}

	public int read() throws IOException
	{
		return is.read();
	}

	public int read(byte[] b) throws IOException
	{
		return is.read(b);
	}

	public int read(byte[] b, int off, int len) throws IOException
	{
		return is.read(b, off, len);
	}

	public void reset() throws IOException
	{
		is.reset();
	}

	public long skip(long n) throws IOException
	{
		return is.skip(n);
	}
}
