package com.one.file;

import java.io.IOException;
import java.io.OutputStream;

/**
 * OutputStream, основанный на FileConnection.
 * При закрытии автоматически закрывает базовый файл.
 */
public class AFCOutputStream extends OutputStream
{
	protected FileConnection fc;
	protected OutputStream os;

	public AFCOutputStream(FileConnection fc) throws IOException
	{
		this.fc = fc;
		os = fc.openOutputStream();
	}

	public void close() throws IOException
	{
		os.close();
		fc.close();
	}

	public void flush() throws IOException
	{
		os.flush();
	}

	public void write(byte[] b) throws IOException
	{
		os.write(b);
	}

	public void write(byte[] b, int off, int len) throws IOException
	{
		os.write(b, off, len);
	}

	public void write(int b) throws IOException
	{
		os.write(b);
	}
}
