package com.one.file;

import com.vmx.AuxClass;
import java.io.IOException;
import java.io.InputStream;

public class DebugInputStream extends InputStream
{
	protected InputStream is;
	protected Object parent;

	public DebugInputStream(InputStream is, Object parent) throws IOException
	{
		this.is = is;
		this.parent = parent;

		AuxClass.out(parent, "InputStream opened");
	}

	public int available() throws IOException
	{
		return is.available();
	}

	public void close() throws IOException
	{
		is.close();
		AuxClass.out(parent, "InputStream closed");
	}

	public void mark(int readLimit)
	{
		is.mark(readLimit);
	}

	public boolean markSuported()
	{
		return is.markSupported();
	}

	public int read() throws IOException
	{
		return is.read();
	}

	public int read(byte[] b) throws IOException
	{
		return is.read(b);
	}

	public int read(byte[] b, int off, int len) throws IOException
	{
		return is.read(b, off, len);
	}

	public void reset() throws IOException
	{
		is.reset();
	}

	public long skip(long n) throws IOException
	{
		return is.skip(n);
	}
}
