package com.one.file;

import com.vmx.AuxClass;
import java.io.IOException;
import java.io.OutputStream;

public class DebugOutputStream extends OutputStream
{
	protected OutputStream os;
	protected Object parent;

	public DebugOutputStream(OutputStream os, Object parent) throws IOException
	{
		this.os = os;
		this.parent = parent;

		AuxClass.out(parent, "OutputStream opened");
	}

	public DebugOutputStream(OutputStream os, Object parent, long byteOffset) throws IOException
	{
		this.os = os;
		this.parent = parent;

		AuxClass.out(parent, "OutputStream opened at " + byteOffset);
	}

	public void close() throws IOException
	{
		os.close();
		AuxClass.out(parent, "OutputStream closed");
	}

	public void flush() throws IOException
	{
		os.flush();
	}

	public void write(byte[] b) throws IOException
	{
		os.write(b);
	}

	public void write(byte[] b, int off, int len) throws IOException
	{
		os.write(b, off, len);
	}

	public void write(int b) throws IOException
	{
		os.write(b);
	}
}
