package com.one.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.Connection;

public class GenericFileConnection implements com.one.file.FileConnection
{
	protected javax.microedition.io.file.FileConnection conn;

	public static Enumeration listRoots()
	{
		return javax.microedition.io.file.FileSystemRegistry.listRoots();
	}

	public GenericFileConnection(Connection conn)
	{
		this.conn = (javax.microedition.io.file.FileConnection)conn;
	}

	public void close() throws IOException
	{
		conn.close();
	}

	public boolean isOpen()
	{
		return conn.isOpen();
	}

	//#if FileDebug == "true"
//#
//# 	public InputStream openInputStream() throws IOException
//# 	{
//# 		return new DebugInputStream(conn.openInputStream(), this);
//# 	}
//#
//# 	public DataInputStream openDataInputStream() throws IOException
//# 	{
//# 		return new DataInputStream(new DebugInputStream(conn.openInputStream(), this));
//# 	}
//#
//# 	public OutputStream openOutputStream() throws IOException
//# 	{
//# 		return new DebugOutputStream(conn.openOutputStream(), this);
//# 	}
//#
//# 	public DataOutputStream openDataOutputStream() throws IOException
//# 	{
//# 		return new DataOutputStream(new DebugOutputStream(conn.openOutputStream(), this));
//# 	}
//#
//# 	public OutputStream openOutputStream(long byteOffset) throws IOException
//# 	{
//# 		return new DebugOutputStream(conn.openOutputStream(byteOffset), this, byteOffset);
//# 	}
//# 	
	//#else

	public InputStream openInputStream() throws IOException
	{
		return conn.openInputStream();
	}

	public DataInputStream openDataInputStream() throws IOException
	{
		return conn.openDataInputStream();
	}

	public OutputStream openOutputStream() throws IOException
	{
		return conn.openOutputStream();
	}

	public DataOutputStream openDataOutputStream() throws IOException
	{
		return conn.openDataOutputStream();
	}

	public OutputStream openOutputStream(long byteOffset) throws IOException
	{
		return conn.openOutputStream(byteOffset);
	}

	//#endif

	public long totalSize()
	{
		return conn.totalSize();
	}

	public long availableSize()
	{
		return conn.availableSize();
	}

	public long usedSize()
	{
		return conn.usedSize();
	}

	public long directorySize(boolean includeSubDirs) throws IOException
	{
		return conn.directorySize(includeSubDirs);
	}

	public long fileSize() throws IOException
	{
		return conn.fileSize();
	}

	public boolean canRead()
	{
		return conn.canRead();
	}

	public boolean canWrite()
	{
		return conn.canWrite();
	}

	public boolean isHidden()
	{
		return conn.isHidden();
	}

	public void setReadable(boolean readable) throws IOException
	{
		conn.setReadable(readable);
	}

	public void setWritable(boolean writable) throws IOException
	{
		conn.setWritable(writable);
	}

	public void setHidden(boolean hidden) throws IOException
	{
		conn.setHidden(hidden);
	}

	public Enumeration list() throws IOException
	{
		return conn.list();
	}

	public Enumeration list(String filter, boolean includeHidden) throws IOException
	{
		return conn.list(filter, includeHidden);
	}

	public void create() throws IOException
	{
		conn.create();
	}

	public void mkdir() throws IOException
	{
		conn.mkdir();
	}

	public boolean exists()
	{
		return conn.exists();
	}

	public boolean isDirectory()
	{
		return conn.isDirectory();
	}

	public void delete() throws IOException
	{
		conn.delete();
	}

	public void rename(String newName) throws IOException
	{
		conn.rename(newName);
	}

	public void truncate(long byteOffset) throws IOException
	{
		conn.truncate(byteOffset);
	}

	public void setFileConnection(String fileName) throws IOException
	{
		conn.setFileConnection(fileName);
	}

	public String getName()
	{
		return conn.getName();
	}

	public String getPath()
	{
		return conn.getPath();
	}

	public String getURL()
	{
		return conn.getURL();
	}

	public long lastModified()
	{
		return conn.lastModified();
	}
}