package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class ArcArray extends VectorElement
{
	protected double[][] data = new double[4][];
	protected int[][] sdata;
	protected int[] colors;
	protected int[] starts;
	protected int[] lengths;
	protected int count;
	protected ArrayData clr, x, y, width, height, start, length;
	
	public ArcArray()
	{
		clr = new ArrayData();
		x = new ArrayData();
		y = new ArrayData();
		width = new ArrayData();
		height = new ArrayData();
		start = new ArrayData();
		length = new ArrayData();
		
		count = 2;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		parseFlag(dis.readUnsignedByte());
		
		count = dis.readUnsignedShort();
		
		clr = new ArrayData(dis);
		x = new ArrayData(dis);
		y = new ArrayData(dis);
		width = new ArrayData(dis);
		height = new ArrayData(dis);
		start = new ArrayData(dis);
		length = new ArrayData(dis);
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeByte(getFlag());
		
		dos.writeShort(count);
		
		clr.write(dos);
		x.write(dos);
		y.write(dos);
		width.write(dos);
		height.write(dos);
		start.write(dos);
		length.write(dos);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		colors = AuxMath.linearArrayRGB(clr, count);
		
		data[0] = AuxMath.specificArrayFloat(x, count);
		data[1] = AuxMath.specificArrayFloat(y, count);
		data[2] = AuxMath.specificArrayFloat(width, count);
		data[3] = AuxMath.specificArrayFloat(height, count);
		
		starts = AuxMath.specificArrayInt(start, count);
		lengths = AuxMath.specificArrayInt(length, count);
		
		sdata = new int[4][count];
	}
	
	public void rescale()
	{
		for(int i = 0; i < count; i++)
		{
			sdata[0][i] = getScaled(data[0][i], 0);
			sdata[1][i] = getScaled(data[1][i], 1);
			sdata[2][i] = getScaled(data[2][i], 2);
			sdata[3][i] = getScaled(data[3][i], 3);
		}
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		g.setStrokeStyle(stroke);
		
		if(group.image.usecolor)
		{
			if(fill)
			{
				for(int i = 0; i < count; i++)
				{
					g.setColor(colors[i]);
					g.fillArc(sdata[0][i], sdata[1][i], sdata[2][i], sdata[3][i], starts[i], lengths[i]);
				}
			}
			else
			{
				for(int i = 0; i < count; i++)
				{
					g.setColor(colors[i]);
					g.drawArc(sdata[0][i], sdata[1][i], sdata[2][i], sdata[3][i], starts[i], lengths[i]);
				}
			}
		}
		else
		{
			if(fill)
			{
				for(int i = 0; i < count; i++)
				{
					g.fillArc(sdata[0][i], sdata[1][i], sdata[2][i], sdata[3][i], starts[i], lengths[i]);
				}
			}
			else
			{
				for(int i = 0; i < count; i++)
				{
					g.drawArc(sdata[0][i], sdata[1][i], sdata[2][i], sdata[3][i], starts[i], lengths[i]);
				}
			}
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		ArrayData v;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				if(param == SHOW)
				{
					setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
				}
				else
				{
					subparam = transform.getSubParam();
					
					if(subparam == 0)
					{
						if(param == INT_A)
						{
							clr.inta = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						}
						else if(param == INT_B)
						{
							clr.intb = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						}
						
						continue;
					}
					else if(subparam == 1)
					{
						v = x;
					}
					else if(subparam == 2)
					{
						v = y;
					}
					else if(subparam == 3)
					{
						v = width;
					}
					else if(subparam == 4)
					{
						v = height;
					}
					else if(subparam == 5)
					{
						v = start;
					}
					else if(subparam == 6)
					{
						v = length;
					}
					else
					{
						continue;
					}
					
					switch(param)
					{
						case VAL_A:
							v.vala = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case VAL_B:
							v.valb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_A:
							v.diva = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_B:
							v.divb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_C:
							v.divc = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_D:
							v.divd = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case INT_A:
							v.inta = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case INT_B:
							v.intb = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
							changed = true;
							break;
					}
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		if(param == COUNT)
		{
			return new Integer(count);
		}
		
		ArrayData v;
		
		if(subparam == 0)
		{
			v = clr;
		}
		else if(subparam == 1)
		{
			v = x;
		}
		else if(subparam == 2)
		{
			v = y;
		}
		else if(subparam == 3)
		{
			v = width;
		}
		else if(subparam == 4)
		{
			v = height;
		}
		else if(subparam == 5)
		{
			v = start;
		}
		else if(subparam == 6)
		{
			v = length;
		}
		else
		{
			return null;
		}
		
		switch(param)
		{
			case VAL_A:
				return new Double(v.vala);
			
			case VAL_B:
				return new Double(v.valb);
			
			case DIV_A:
				return new Double(v.diva);
			
			case DIV_B:
				return new Double(v.divb);
			
			case DIV_C:
				return new Double(v.divc);
			
			case DIV_D:
				return new Double(v.divd);
			
			case INT_A:
				return new Integer(v.inta);
			
			case INT_B:
				return new Integer(v.intb);
			
			case FUNCTION:
				return new Integer(v.type);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		if(param == COUNT)
		{
			count = ((Integer)value).intValue();
			return;
		}
		
		ArrayData v;
		
		if(subparam == 0)
		{
			v = clr;
		}
		else if(subparam == 1)
		{
			v = x;
		}
		else if(subparam == 2)
		{
			v = y;
		}
		else if(subparam == 3)
		{
			v = width;
		}
		else if(subparam == 4)
		{
			v = height;
		}
		else if(subparam == 5)
		{
			v = start;
		}
		else if(subparam == 6)
		{
			v = length;
		}
		else
		{
			return;
		}
		
		switch(param)
		{
			case VAL_A:
				v.vala = ((Double)value).doubleValue();
				break;
			
			case VAL_B:
				v.valb = ((Double)value).doubleValue();
				break;
			
			case DIV_A:
				v.diva = ((Double)value).doubleValue();
				break;
			
			case DIV_B:
				v.divb = ((Double)value).doubleValue();
				break;
			
			case DIV_C:
				v.divc = ((Double)value).doubleValue();
				break;
			
			case DIV_D:
				v.divd = ((Double)value).doubleValue();
				break;
			
			case INT_A:
				v.inta = ((Integer)value).intValue();
				break;
			
			case INT_B:
				v.intb = ((Integer)value).intValue();
				break;
			
			case FUNCTION:
				v.type = ((Integer)value).intValue();
				break;
		}
	}
}