package com.one.vector;

import java.io.*;

public class ArrayData
{
	public static final int LINEAR = 0;
	public static final int INTEGER = 1;
	public static final int HARMONIC = 2;
	public static final int CUBIC = 3;
	
	public double vala, valb;
	public double diva, divb, divc, divd;
	public int inta, intb;
	public int type;
	
	public ArrayData()
	{
	}
	
	public ArrayData(double vala, double valb)
	{
		this.vala = vala;
		this.valb = valb;
		
		this.type = LINEAR;
	}
	
	public ArrayData(int inta, int intb)
	{
		this.inta = inta;
		this.intb = intb;
		
		this.type = INTEGER;
	}
	
	public ArrayData(double vala, double valb, double diva, double divb, int inta, int intb)
	{
		this.vala = vala;
		this.valb = valb;
		this.diva = diva;
		this.divb = divb;
		this.inta = inta;
		this.intb = intb;
		
		this.type = HARMONIC;
	}
	
	public ArrayData(double vala, double valb, double diva, double divb, double divc, double divd)
	{
		this.vala = vala;
		this.valb = valb;
		this.diva = diva;
		this.divb = divb;
		this.divc = divc;
		this.divd = divd;
		
		this.type = CUBIC;
	}
	
	public ArrayData(DataInputStream dis) throws IOException
	{
		read(dis);
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		type = dis.readUnsignedByte();
		
		switch(type)
		{
			case LINEAR:
				vala = dis.readFloat();
				valb = dis.readFloat();
				break;
			
			case INTEGER:
				inta = dis.readInt();
				intb = dis.readInt();
				break;
			
			case HARMONIC:
				vala = dis.readFloat();
				valb = dis.readFloat();
				diva = dis.readFloat();
				divb = dis.readFloat();
				inta = dis.readInt();
				intb = dis.readInt();
				break;
			
			case CUBIC:
				vala = dis.readFloat();
				valb = dis.readFloat();
				diva = dis.readFloat();
				divb = dis.readFloat();
				divc = dis.readFloat();
				divd = dis.readFloat();
				break;
		}
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeByte(type);
		
		switch(type)
		{
			case LINEAR:
				dos.writeFloat((float)vala);
				dos.writeFloat((float)valb);
				break;
			
			case INTEGER:
				dos.writeInt(inta);
				dos.writeInt(intb);
				break;
			
			case HARMONIC:
				dos.writeFloat((float)vala);
				dos.writeFloat((float)valb);
				dos.writeFloat((float)diva);
				dos.writeFloat((float)divb);
				dos.writeInt(inta);
				dos.writeInt(intb);
				break;
			
			case CUBIC:
				dos.writeFloat((float)vala);
				dos.writeFloat((float)valb);
				dos.writeFloat((float)diva);
				dos.writeFloat((float)divb);
				dos.writeFloat((float)divc);
				dos.writeFloat((float)divd);
				break;
		}
	}
}