package com.one.vector;

import java.io.*;

public class BitwiseFunction extends Effect
{
	public static final int OR = 0;
	public static final int XOR = 1;
	public static final int AND = 2;
	
	public static final String[] FUNCTIONS =
	{
		"OR", "XOR", "AND"
	};
	
	protected int type;
	protected int value;
	
	public BitwiseFunction()
	{
		type = OR;
		value = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		hidden = dis.readBoolean();
		
		type = dis.readUnsignedByte();
		value = dis.readInt();
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeBoolean(hidden);
		
		dos.writeByte(type);
		dos.writeInt(value);
	}
	
	public void apply(int[] rgb, int[] temp, int width, int height)
	{
		if(hidden)
		{
			return;
		}
		
		if(type == OR)
		{
			for(int i = 0; i < rgb.length; i++)
			{
				rgb[i] |= value;
			}
		}
		else if(type == XOR)
		{
			for(int i = 0; i < rgb.length; i++)
			{
				rgb[i] ^= value;
			}
		}
		else if(type == AND)
		{
			for(int i = 0; i < rgb.length; i++)
			{
				rgb[i] &= value;
			}
		}
	}
	
	public void setType(int type)
	{
		this.type = type;
	}
	
	public void setValue(int value)
	{
		this.value = value;
	}
	
	public int getType()
	{
		return type;
	}
	
	public int getValue()
	{
		return value;
	}
}