package com.one.vector;

import java.io.*;

public class ColorReplace extends Effect
{
	protected int startcolor, endcolor;
	
	public ColorReplace()
	{
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		hidden = dis.readBoolean();
		
		startcolor = dis.readInt();
		endcolor = dis.readInt();
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeBoolean(hidden);
		
		dos.writeInt(startcolor);
		dos.writeInt(endcolor);
	}
	
	public void apply(int[] rgb, int[] temp, int width, int height)
	{
		if(hidden)
		{
			return;
		}
		
		for(int i = 0; i < rgb.length; i++)
		{
			if(rgb[i] == startcolor)
			{
				rgb[i] = endcolor;
			}
		}
	}
	
	public void setStartColor(int color)
	{
		startcolor = color;
	}
	
	public void setEndColor(int color)
	{
		endcolor = color;
	}
	
	public int getStartColor()
	{
		return startcolor;
	}
	
	public int getEndColor()
	{
		return endcolor;
	}
}