package com.one.vector;

import com.one.AbstractFont;
import java.io.*;

public class Comment
{
	protected String name;
	
	protected String text;
	protected AbstractFont font;
	
	protected int backcolor;
	protected int forecolor;
	
	protected int startframe;
	protected int endframe;
	
	public Comment()
	{
		name = VectorElement.defaultName();
		
		text = "";
		font = AbstractFont.getDefaultFont();
		
		backcolor = 0;
		forecolor = -1;
		
		startframe = -1;
		endframe = -1;
	}
	
	public Comment(DataInputStream dis) throws IOException
	{
		read(dis);
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		
		text = dis.readUTF();
		font = AbstractFont.getFont(dis.readInt(), dis.readInt(), dis.readInt());
		
		backcolor = dis.readInt();
		forecolor = dis.readInt();
		
		startframe = dis.readInt();
		endframe = dis.readInt();
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		
		dos.writeUTF(text);
		
		dos.writeInt(font.getFace());
		dos.writeInt(font.getStyle());
		dos.writeInt(font.getSize());
		
		dos.writeInt(backcolor);
		dos.writeInt(forecolor);
		
		dos.writeInt(startframe);
		dos.writeInt(endframe);
	}
	
	public void setName(String nm)
	{
		if(nm != null)
		{
			name = nm;
		}
		else
		{
			name = VectorElement.defaultName();
		}
	}
	
	public String getName()
	{
		return name;
	}
	
	public void setText(String txt)
	{
		if(txt != null)
		{
			text = txt;
		}
		else
		{
			text = "";
		}
	}
	
	public String getText()
	{
		return text;
	}
	
	public void setFont(AbstractFont font)
	{
		this.font = font;
	}
	
	public AbstractFont getFont()
	{
		return font;
	}
	
	public void setColor(int backcolor, int forecolor)
	{
		this.backcolor = backcolor;
		this.forecolor = forecolor;
	}
	
	public int getBackColor()
	{
		return backcolor;
	}
	
	public int getForeColor()
	{
		return forecolor;
	}
	
	public void setBounds(int startframe, int endframe)
	{
		this.startframe = startframe;
		this.endframe = endframe;
	}
	
	public int getStartFrame()
	{
		return startframe;
	}
	
	public int getEndFrame()
	{
		return endframe;
	}
	
	public boolean isVisible(int frame)
	{
		if(startframe < 0)
		{
			return false;
		}
		else
		{
			if(endframe < 0)
			{
				return true;
			}
			else
			{
				if(frame >= startframe && frame <= endframe)
				{
					return true;
				}
				else
				{
					return false;
				}
			}
		}
	}
}