package com.one.vector;

import java.io.*;

public abstract class Effect
{
	public static final int COLOR_REPLACE = 0,
							AREA_FILL = 1,
							LINE_FILL = 2,
							CHANNEL_MATRIX = 3,
							PIXEL_MATRIX = 4,
							BITWISE_FUNCTION = 5,
							GRADIENT_REPLACE = 6;
	
	protected String name;
	protected boolean hidden;
	
	public Effect()
	{
		name = VectorElement.defaultName();
		hidden = false;
	}
	
	public abstract void read(DataInputStream dis) throws IOException;
	public abstract void write(DataOutputStream dos) throws IOException;
	
	public abstract void apply(int[] rgb, int[] temp, int width, int height);
	
	public void setName(String nm)
	{
		if(nm != null)
		{
			name = nm;
		}
		else
		{
			name = VectorElement.defaultName();
		}
	}
	
	public String getName()
	{
		return name;
	}
	
	public void setHidden(boolean hidden)
	{
		this.hidden = hidden;
	}
	
	public boolean isHidden()
	{
		return hidden;
	}
	
	public static Effect getInstance(int type)
	{
		switch(type)
		{
			case COLOR_REPLACE:
				return new ColorReplace();
			
			case AREA_FILL:
				return new AreaFill();
			
			case LINE_FILL:
				return new LineFill();
			
			case CHANNEL_MATRIX:
				return new ChannelMatrix();
			
			case PIXEL_MATRIX:
				return new PixelMatrix();
			
			case BITWISE_FUNCTION:
				return new BitwiseFunction();
			
			case GRADIENT_REPLACE:
				return new GradientReplace();
			
			default:
				throw new IllegalArgumentException("Unknown effect type: " + Integer.toString(type));
				//throw new IllegalArgumentException();
		}
	}
	
	public static int effectType(Effect effect)
	{
		if(effect instanceof ColorReplace)
		{
			return COLOR_REPLACE;
		}
		else if(effect instanceof AreaFill)
		{
			return AREA_FILL;
		}
		else if(effect instanceof LineFill)
		{
			return LINE_FILL;
		}
		else if(effect instanceof ChannelMatrix)
		{
			return CHANNEL_MATRIX;
		}
		else if(effect instanceof PixelMatrix)
		{
			return PIXEL_MATRIX;
		}
		else if(effect instanceof BitwiseFunction)
		{
			return BITWISE_FUNCTION;
		}
		else if(effect instanceof GradientReplace)
		{
			return GRADIENT_REPLACE;
		}
		else
		{
			//throw new IllegalArgumentException("Unknown effect: " + effect.getClass().getName());
			throw new IllegalArgumentException();
		}
	}
}