package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class GradientRect extends VectorElement
{
	protected double[][] data = new double[4][];
	protected int[][] sdata;
	protected int[] colors;
	protected int count;
	protected ArrayData pdata;
	protected int angle;
	
	public GradientRect()
	{
		pdata = new ArrayData();
		pdata.type = ArrayData.HARMONIC;
		
		count = 3;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		parseFlag(dis.readUnsignedByte());
		
		pdata = new ArrayData(dis);
		angle = dis.readShort();
		count = dis.readUnsignedShort() + 1;
		
		readTransformList(dis);
	}
		
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeByte(getFlag());
		
		pdata.write(dos);
		dos.writeShort(angle);
		dos.writeShort(count - 1);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		double[] r = AuxMath.plotRotRect(pdata.vala, pdata.valb, pdata.diva, pdata.divb, angle);
		
		data[0] = AuxMath.specificArrayFloat(new ArrayData(r[0], r[4]), count);
		data[1] = AuxMath.specificArrayFloat(new ArrayData(r[1], r[5]), count);
		data[2] = AuxMath.specificArrayFloat(new ArrayData(r[2], r[6]), count);
		data[3] = AuxMath.specificArrayFloat(new ArrayData(r[3], r[7]), count);
		
		colors = AuxMath.linearArrayRGB(new ArrayData(pdata.inta, pdata.intb), count - 1);
		
		sdata = new int[4][count];
	}
	
	public void rescale()
	{
		for(int i = 0; i < count; i++)
		{
			sdata[0][i] = getScaled(data[0][i], 0);
			sdata[1][i] = getScaled(data[1][i], 1);
			sdata[2][i] = getScaled(data[2][i], 0);
			sdata[3][i] = getScaled(data[3][i], 1);
		}
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(group.image.usecolor)
		{
			for(int i = 1; i < count; i++)
			{
				g.setColor(colors[i - 1]);
				
				g.fillTriangle(sdata[0][i], sdata[1][i], sdata[0][i - 1], sdata[1][i - 1], sdata[2][i - 1], sdata[3][i - 1]);
				g.fillTriangle(sdata[0][i], sdata[1][i], sdata[2][i], sdata[3][i], sdata[2][i - 1], sdata[3][i - 1]);
			}
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				subparam = transform.getSubParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						switch(subparam)
						{
							case 0:
								pdata.inta = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 1:
								pdata.intb = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
						break;
					
					case X:
						pdata.vala = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case Y:
						pdata.valb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case WIDTH:
						pdata.diva = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case HEIGHT:
						pdata.divb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case ANGLE:
						angle = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
						changed = true;
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		switch(param)
		{
			case COLOR:
				if(subparam == 0)
				{
					return new Integer(pdata.inta);
				}
				else if(subparam == 1)
				{
					return new Integer(pdata.intb);
				}
				else
				{
					return null;
				}
			
			case X:
				return new Double(pdata.vala);
			
			case Y:
				return new Double(pdata.valb);
			
			case WIDTH:
				return new Double(pdata.diva);
			
			case HEIGHT:
				return new Double(pdata.divb);
			
			case ANGLE:
				return new Integer(angle);
			
			case QUALITY:
				return new Integer(count - 1);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		switch(param)
		{
			case COLOR:
				if(subparam == 0)
				{
					pdata.inta = ((Integer)value).intValue();
				}
				else if(subparam == 1)
				{
					pdata.intb = ((Integer)value).intValue();
				}
				break;
			
			case X:
				pdata.vala = ((Double)value).doubleValue();
				break;
			
			case Y:
				pdata.valb = ((Double)value).doubleValue();
				break;
			
			case WIDTH:
				pdata.diva = ((Double)value).doubleValue();
				break;
			
			case HEIGHT:
				pdata.divb = ((Double)value).doubleValue();
				break;
			
			case ANGLE:
				angle = ((Integer)value).intValue();
				break;
			
			case QUALITY:
				count = ((Integer)value).intValue() + 1;
				break;
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.println("\t\t\t<g>");
		
		for(int i = 1; i < count; i++)
		{
			ps.print("\t\t\t\t<polygon");
			
			ps.print(" points=\"");
			ps.print(Integer.toString(sdata[0][i]) + " " + Integer.toString(sdata[1][i]));
			ps.print(", " + Integer.toString(sdata[2][i]) + " " + Integer.toString(sdata[3][i]));
			ps.print(", " + Integer.toString(sdata[2][i - 1]) + " " + Integer.toString(sdata[3][i - 1]));
			ps.print(", " + Integer.toString(sdata[0][i - 1]) + " " + Integer.toString(sdata[1][i - 1]));
			ps.print("\"");
			
			ps.print(" stroke=\"" + formatColor(colors[i - 1]) + "\"");
			ps.print(" fill=\"" + formatColor(colors[i - 1]) + "\"");
			
			ps.println("/>");
		}
		
		ps.println("\t\t\t</g>");
	}
}