package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class Line extends VectorElement
{
	protected double[] data = new double[4];
	protected int[] sdata = new int[4];
	
	public Line()
	{
		data[0] = 0;
		data[1] = 0;
		data[2] = 0;
		data[3] = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		data[0] = dis.readFloat();
		data[1] = dis.readFloat();
		data[2] = dis.readFloat();
		data[3] = dis.readFloat();
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeFloat((float)data[0]);
		dos.writeFloat((float)data[1]);
		dos.writeFloat((float)data[2]);
		dos.writeFloat((float)data[3]);
		
		writeTransformList(dos);
	}
	
	public void rescale()
	{
		sdata[0] = getScaled(data[0], 0);
		sdata[1] = getScaled(data[1], 1);
		sdata[2] = getScaled(data[2], 0);
		sdata[3] = getScaled(data[3], 1);
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(group.image.usecolor)
		{
			g.setColor(color);
		}
		
		g.setStrokeStyle(stroke);
		g.drawLine(sdata[0], sdata[1], sdata[2], sdata[3]);
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				subparam = transform.getSubParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						break;
					
					case X:
						switch(subparam)
						{
							case 1:
								data[0] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 2:
								data[2] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
						break;
					
					case Y:
						switch(subparam)
						{
							case 1:
								data[1] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
							
							case 2:
								data[3] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
								changed = true;
								break;
						}
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		if(param == X)
		{
			if(subparam == 1)
			{
				return new Double(data[0]);
			}
			else if(subparam == 2)
			{
				return new Double(data[2]);
			}
		}
		else if(param == Y)
		{
			if(subparam == 1)
			{
				return new Double(data[1]);
			}
			else if(subparam == 2)
			{
				return new Double(data[3]);
			}
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		if(param == X)
		{
			if(subparam == 1)
			{
				data[0] = ((Double)value).doubleValue();
			}
			else if(subparam == 2)
			{
				data[2] = ((Double)value).doubleValue();
			}
		}
		else if(param == Y)
		{
			if(subparam == 1)
			{
				data[1] = ((Double)value).doubleValue();
			}
			else if(subparam == 2)
			{
				data[3] = ((Double)value).doubleValue();
			}
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<line");
		
		ps.print(" x1=\"" + Integer.toString(sdata[0]) + "\"");
		ps.print(" y1=\"" + Integer.toString(sdata[1]) + "\"");
		ps.print(" x2=\"" + Integer.toString(sdata[2]) + "\"");
		ps.print(" y2=\"" + Integer.toString(sdata[3]) + "\"");
		
		writeSVGTail(ps, true, false);
		
		ps.println("/>");
	}
}