package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class LineArray extends VectorElement
{
	protected double[][] data = new double[4][];
	protected int[][] sdata;
	protected int[] colors;
	protected int count;
	protected ArrayData clr, x1, y1, x2, y2;
	
	public LineArray()
	{
		clr = new ArrayData();
		x1 = new ArrayData();
		y1 = new ArrayData();
		x2 = new ArrayData();
		y2 = new ArrayData();
		
		count = 2;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		parseFlag(dis.readUnsignedByte());
		
		count = dis.readUnsignedShort();
		
		clr = new ArrayData(dis);
		x1 = new ArrayData(dis);
		y1 = new ArrayData(dis);
		x2 = new ArrayData(dis);
		y2 = new ArrayData(dis);
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeByte(getFlag());
		
		dos.writeShort(count);
		
		clr.write(dos);
		x1.write(dos);
		y1.write(dos);
		x2.write(dos);
		y2.write(dos);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		colors = AuxMath.linearArrayRGB(clr, count);
		
		data[0] = AuxMath.specificArrayFloat(x1, count);
		data[1] = AuxMath.specificArrayFloat(y1, count);
		data[2] = AuxMath.specificArrayFloat(x2, count);
		data[3] = AuxMath.specificArrayFloat(y2, count);
		
		sdata = new int[4][count];
	}
	
	public void rescale()
	{
		for(int i = 0; i < count; i++)
		{
			sdata[0][i] = getScaled(data[0][i], 0);
			sdata[1][i] = getScaled(data[1][i], 1);
			sdata[2][i] = getScaled(data[2][i], 0);
			sdata[3][i] = getScaled(data[3][i], 1);
		}
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		g.setStrokeStyle(stroke);
		
		if(group.image.usecolor)
		{
			for(int i = 0; i < count; i++)
			{
				g.setColor(colors[i]);
				g.drawLine(sdata[0][i], sdata[1][i], sdata[2][i], sdata[3][i]);
			}
		}
		else
		{
			for(int i = 0; i < count; i++)
			{
				g.drawLine(sdata[0][i], sdata[1][i], sdata[2][i], sdata[3][i]);
			}
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		ArrayData v;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				if(param == SHOW)
				{
					setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
				}
				else
				{
					subparam = transform.getSubParam();
					
					if(subparam == 0)
					{
						if(param == INT_A)
						{
							clr.inta = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						}
						else if(param == INT_B)
						{
							clr.intb = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						}
						
						continue;
					}
					else if(subparam == 1)
					{
						v = x1;
					}
					else if(subparam == 2)
					{
						v = y1;
					}
					else if(subparam == 3)
					{
						v = x2;
					}
					else if(subparam == 4)
					{
						v = y2;
					}
					else
					{
						continue;
					}
					
					switch(param)
					{
						case VAL_A:
							v.vala = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case VAL_B:
							v.valb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_A:
							v.diva = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_B:
							v.divb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_C:
							v.divc = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_D:
							v.divd = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case INT_A:
							v.inta = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case INT_B:
							v.intb = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
							changed = true;
							break;
					}
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		if(param == COUNT)
		{
			return new Integer(count);
		}
		
		ArrayData v;
		
		if(subparam == 0)
		{
			v = clr;
		}
		else if(subparam == 1)
		{
			v = x1;
		}
		else if(subparam == 2)
		{
			v = y1;
		}
		else if(subparam == 3)
		{
			v = x2;
		}
		else if(subparam == 4)
		{
			v = y2;
		}
		else
		{
			return null;
		}
		
		switch(param)
		{
			case VAL_A:
				return new Double(v.vala);
			
			case VAL_B:
				return new Double(v.valb);
			
			case DIV_A:
				return new Double(v.diva);
			
			case DIV_B:
				return new Double(v.divb);
			
			case DIV_C:
				return new Double(v.divc);
			
			case DIV_D:
				return new Double(v.divd);
			
			case INT_A:
				return new Integer(v.inta);
			
			case INT_B:
				return new Integer(v.intb);
			
			case FUNCTION:
				return new Integer(v.type);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		if(param == COUNT)
		{
			count = ((Integer)value).intValue();
			return;
		}
		
		ArrayData v;
		
		if(subparam == 0)
		{
			v = clr;
		}
		else if(subparam == 1)
		{
			v = x1;
		}
		else if(subparam == 2)
		{
			v = y1;
		}
		else if(subparam == 3)
		{
			v = x2;
		}
		else if(subparam == 4)
		{
			v = y2;
		}
		else
		{
			return;
		}
		
		switch(param)
		{
			case VAL_A:
				v.vala = ((Double)value).doubleValue();
				break;
			
			case VAL_B:
				v.valb = ((Double)value).doubleValue();
				break;
			
			case DIV_A:
				v.diva = ((Double)value).doubleValue();
				break;
			
			case DIV_B:
				v.divb = ((Double)value).doubleValue();
				break;
			
			case DIV_C:
				v.divc = ((Double)value).doubleValue();
				break;
			
			case DIV_D:
				v.divd = ((Double)value).doubleValue();
				break;
			
			case INT_A:
				v.inta = ((Integer)value).intValue();
				break;
			
			case INT_B:
				v.intb = ((Integer)value).intValue();
				break;
			
			case FUNCTION:
				v.type = ((Integer)value).intValue();
				break;
		}
	}
}