package com.one.vector;

import java.io.*;

public class LineFill extends Effect
{
	protected int color;
	
	public LineFill()
	{
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		hidden = dis.readBoolean();
		
		color = dis.readInt();
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeBoolean(hidden);
		
		dos.writeInt(color);
	}
	
	public void apply(int[] rgb, int[] temp, int width, int height)
	{
		if(hidden)
		{
			return;
		}
		
		boolean enabled = false;
		boolean active = true;
		
		for(int i = 0; i < rgb.length; i++)
		{
			if(rgb[i] == color)
			{
				if(active)
				{
					enabled = !enabled;
					active = false;
				}
			}
			else
			{
				if(enabled)
				{
					rgb[i] = color;
				}
				
				active = true;
			}
		}
	}
	
	public void setColor(int color)
	{
		this.color = color;
	}
	
	public int getColor()
	{
		return color;
	}
}