package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class ParametricCurve extends VectorElement
{
	protected ArrayData x, y;
	protected double[][] data = new double[2][];
	protected int[][] sdata = new int[2][];
	protected int count;
	
	public ParametricCurve()
	{
		x = new ArrayData();
		y = new ArrayData();
		
		count = 3;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		count = dis.readUnsignedShort() + 1;
		
		x = new ArrayData(dis);
		y = new ArrayData(dis);
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeShort(count - 1);
		
		x.write(dos);
		y.write(dos);
		
		writeTransformList(dos);
	}
	
	public void create()
	{
		data[0] = AuxMath.specificArrayFloat(x, count);
		data[1] = AuxMath.specificArrayFloat(y, count);
		
		sdata = new int[2][count];
	}
	
	public void rescale()
	{
		for(int i = 0; i < count; i++)
		{
			sdata[0][i] = getScaled(data[0][i], 0);
			sdata[1][i] = getScaled(data[1][i], 1);
		}
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(group.image.usecolor)
		{
			g.setColor(color);
		}
		
		g.setStrokeStyle(stroke);
		
		for(int i = 1; i < count; i++)
		{
			g.drawLine(sdata[0][i], sdata[1][i], sdata[0][i - 1], sdata[1][i - 1]);
		}
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param, subparam;
		ArrayData v;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				if(param == SHOW)
				{
					setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
				}
				else if(param == COLOR)
				{
					color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
				}
				else
				{
					subparam = transform.getSubParam();
					
					if(subparam == 0)
					{
						v = x;
					}
					else if(subparam == 1)
					{
						v = y;
					}
					else
					{
						continue;
					}
					
					switch(param)
					{
						case VAL_A:
							v.vala = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case VAL_B:
							v.valb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_A:
							v.diva = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_B:
							v.divb = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_C:
							v.divc = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case DIV_D:
							v.divd = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case INT_A:
							v.inta = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
							changed = true;
							break;
						
						case INT_B:
							v.intb = AuxMath.specificFunctionInt(transform.getData(), transform.getPosition());
							changed = true;
							break;
					}
				}
			}
		}
		
		if(flag && changed)
		{
			create();
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		if(param == QUALITY)
		{
			return new Integer(count - 1);
		}
		
		ArrayData v;
		
		if(subparam == 0)
		{
			v = x;
		}
		else if(subparam == 1)
		{
			v = y;
		}
		else
		{
			return null;
		}
		
		switch(param)
		{
			case VAL_A:
				return new Double(v.vala);
			
			case VAL_B:
				return new Double(v.valb);
			
			case DIV_A:
				return new Double(v.diva);
			
			case DIV_B:
				return new Double(v.divb);
			
			case DIV_C:
				return new Double(v.divc);
			
			case DIV_D:
				return new Double(v.divd);
			
			case INT_A:
				return new Integer(v.inta);
			
			case INT_B:
				return new Integer(v.intb);
			
			case FUNCTION:
				return new Integer(v.type);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		if(param == QUALITY)
		{
			count = ((Integer)value).intValue() + 1;
			return;
		}
		
		ArrayData v;
		
		if(subparam == 0)
		{
			v = x;
		}
		else if(subparam == 1)
		{
			v = y;
		}
		else
		{
			return;
		}
		
		switch(param)
		{
			case VAL_A:
				v.vala = ((Double)value).doubleValue();
				break;
			
			case VAL_B:
				v.valb = ((Double)value).doubleValue();
				break;
			
			case DIV_A:
				v.diva = ((Double)value).doubleValue();
				break;
			
			case DIV_B:
				v.divb = ((Double)value).doubleValue();
				break;
			
			case DIV_C:
				v.divc = ((Double)value).doubleValue();
				break;
			
			case DIV_D:
				v.divd = ((Double)value).doubleValue();
				break;
			
			case INT_A:
				v.inta = ((Integer)value).intValue();
				break;
			
			case INT_B:
				v.intb = ((Integer)value).intValue();
				break;
			
			case FUNCTION:
				v.type = ((Integer)value).intValue();
				break;
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<polyline");
		
		ps.print(" points=\"");
		ps.print(Integer.toString(sdata[0][0]) + " " + Integer.toString(sdata[1][0]));
		
		for(int i = 1; i < count; i++)
		{
			ps.print(", " + Integer.toString(sdata[0][i]) + " " + Integer.toString(sdata[1][i]));
		}
		
		ps.print("\"");
		
		writeSVGTail(ps, true, false);
		
		ps.println("/>");
	}
}