package com.one.vector;

import javax.microedition.lcdui.Graphics;
import java.io.*;

public class Point extends VectorElement
{
	protected double[] data = new double[2];
	protected int[] sdata = new int[2];
	
	public Point()
	{
		data[0] = 0;
		data[1] = 0;
	}
	
	public void read(DataInputStream dis) throws IOException
	{
		name = dis.readUTF();
		color = dis.readInt();
		parseFlag(dis.readUnsignedByte());
		
		data[0] = dis.readFloat();
		data[1] = dis.readFloat();
		
		readTransformList(dis);
	}
	
	public void write(DataOutputStream dos) throws IOException
	{
		dos.writeUTF(name);
		dos.writeInt(color);
		dos.writeByte(getFlag());
		
		dos.writeFloat((float)data[0]);
		dos.writeFloat((float)data[1]);
		
		writeTransformList(dos);
	}
	
	public void rescale()
	{
		sdata[0] = getScaled(data[0], 0);
		sdata[1] = getScaled(data[1], 1);
	}
	
	public void paint(Graphics g)
	{
		if(hidden)
		{
			return;
		}
		
		if(group.image.usecolor)
		{
			g.setColor(color);
		}
		
		g.setStrokeStyle(stroke);
		g.drawLine(sdata[0], sdata[1], sdata[0], sdata[1]);
	}
	
	public void update(boolean flag, boolean changed)
	{
		Transform transform;
		int param;
		
		for(int i = 0; i < transcount; i++)
		{
			transform = (Transform)transforms.elementAt(i);
			transform.setFrame(group.image.frame);
			
			if(transform.isApplied())
			{
				param = transform.getParam();
				
				switch(param)
				{
					case SHOW:
						setHidden(AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition()));
						break;
					
					case COLOR:
						color = AuxMath.linearFunctionRGB(transform.getData(), transform.getPosition());
						break;
					
					case X:
						data[0] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
					
					case Y:
						data[1] = AuxMath.specificFunctionFloat(transform.getData(), transform.getPosition());
						changed = true;
						break;
				}
			}
		}
		
		if(flag && changed)
		{
			rescale();
		}
	}
	
	public Object getValue(int param, int subparam)
	{
		switch(param)
		{
			case X:
				return new Double(data[0]);
			
			case Y:
				return new Double(data[1]);
		}
		
		return null;
	}
	
	public void setValue(Object value, int param, int subparam)
	{
		switch(param)
		{
			case X:
				data[0] = ((Double)value).doubleValue();
				break;
			
			case Y:
				data[1] = ((Double)value).doubleValue();
				break;
		}
	}
	
	public void writeSVG(PrintStream ps)
	{
		ps.print("\t\t\t<circle");
		
		ps.print(" cx=\"" + Integer.toString(sdata[0]) + "\"");
		ps.print(" cy=\"" + Integer.toString(sdata[1]) + "\"");
		
		ps.print(" r=\"1\"");
		ps.print(" fill=\"" + formatColor(color) + "\"");
		
		writeSVGTail(ps, false, false);
		
		ps.println("/>");
	}
}